# Chronic Illness and Disability Payment System (CDPS) - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chronic Illness and Disability Payment System (CDPS)**

## NamingSystem: Chronic Illness and Disability Payment System (CDPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDPS | *Version*:1.0.0 | |
| Active as of 2023-08-22 | *Responsible:*[UC San Diego](https://ucsd.edu/) | *Computable Name*:CDPS |
| **Copyright/Legal**: For licensing CDPS including MRX and CDPS+MRx, please contact Subramanian (Subbu) Venkatraman at:[suvenkatraman@ucsd.edu](mailto:suvenkatraman@ucsd.edu) | | |

 
"The Chronic Illness and Disability Payment System (CDPS) is a diagnostic-based risk adjustment model that is widely used to adjust capitated payments for health plans that enroll Medicaid beneficiaries. 
CDPS uses International Classification of Disease (ICD) codes to assign CDPS Categories that indicate illness burden related to major body systems (e.g. cardiovascular) or types of chronic disease (e.g. diabetes). Within each major category is a hierarchy reflecting both the clinical severity of the condition and its expected effect on future costs. Each of the hierarchical CDPS Categories is assigned a CDPS weight. CDPS weights are additive across major categories." 
"The CDPS model was developed in 2000 using data from seven Fee-for-Service (FFS) Medicaid programs. The model received major updates in 2009 (using national FFS Medicaid data from 2002-2005) and in 2014 (using additional national FFS Medicaid data from 2011). CDPS has also received regular annual updates to include the most recent ICD and NDC codes." 
For more information, please visit[https://hwsph.ucsd.edu/research/programs-groups/cdps.html](https://hwsph.ucsd.edu/research/programs-groups/cdps.html). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CDPS |
| Version | 1.0.0 |
| Name | CDPS |
| Title | Chronic Illness and Disability Payment System (CDPS) |
| Status | active |
| Definition | "The Chronic Illness and Disability Payment System (CDPS) is a diagnostic-based risk adjustment model that is widely used to adjust capitated payments for health plans that enroll Medicaid beneficiaries.CDPS uses International Classification of Disease (ICD) codes to assign CDPS Categories that indicate illness burden related to major body systems (e.g. cardiovascular) or types of chronic disease (e.g. diabetes). Within each major category is a hierarchy reflecting both the clinical severity of the condition and its expected effect on future costs. Each of the hierarchical CDPS Categories is assigned a CDPS weight. CDPS weights are additive across major categories.""The CDPS model was developed in 2000 using data from seven Fee-for-Service (FFS) Medicaid programs. The model received major updates in 2009 (using national FFS Medicaid data from 2002-2005) and in 2014 (using additional national FFS Medicaid data from 2011). CDPS has also received regular annual updates to include the most recent ICD and NDC codes."For more information, please visit [https://hwsph.ucsd.edu/research/programs-groups/cdps.html](https://hwsph.ucsd.edu/research/programs-groups/cdps.html). |
| Publisher | UC San Diego |
| Copyright | For licensing CDPS including MRX and CDPS+MRx, please contact Subramanian (Subbu) Venkatraman at: [suvenkatraman@ucsd.edu](mailto:suvenkatraman@ucsd.edu) |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/CDPS
  * **Preferred**: true
  * **Period**: 2023-08-21 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDPS",
  "url" : "http://terminology.hl7.org/NamingSystem/CDPS",
  "version" : "1.0.0",
  "name" : "CDPS",
  "title" : "Chronic Illness and Disability Payment System (CDPS)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-08-22T00:00:00-00:00",
  "publisher" : "UC San Diego",
  "contact" : [
    {
      "name" : "UC San Diego; 9500 Gilman Dr. La Jolla, CA 92093",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "(858) 534-2230"
        },
        {
          "system" : "url",
          "value" : "https://ucsd.edu/"
        }
      ]
    }
  ],
  "description" : "\"The Chronic Illness and Disability Payment System (CDPS) is a diagnostic-based risk adjustment model that is widely used to adjust capitated payments for health plans that enroll Medicaid beneficiaries.\r\n\r\nCDPS uses International Classification of Disease (ICD) codes to assign CDPS Categories that indicate illness burden related to major body systems (e.g. cardiovascular) or types of chronic disease (e.g. diabetes). Within each major category is a hierarchy reflecting both the clinical severity of the condition and its expected effect on future costs. Each of the hierarchical CDPS Categories is assigned a CDPS weight. CDPS weights are additive across major categories.\"\r\n\r\n\"The CDPS model was developed in 2000 using data from seven Fee-for-Service (FFS) Medicaid programs.  The model received major updates in 2009 (using national FFS Medicaid data from 2002-2005) and in 2014 (using additional national FFS Medicaid data from 2011). CDPS has also received regular annual updates to include the most recent ICD and NDC codes.\"\r\n\r\nFor more information, please visit [https://hwsph.ucsd.edu/research/programs-groups/cdps.html](https://hwsph.ucsd.edu/research/programs-groups/cdps.html).",
  "copyright" : "For licensing CDPS including MRX and CDPS+MRx, please contact Subramanian (Subbu) Venkatraman at: [suvenkatraman@ucsd.edu](mailto:suvenkatraman@ucsd.edu)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/CDPS",
      "preferred" : true,
      "period" : {
        "start" : "2023-08-21"
      }
    }
  ]
}

```
