# NHSN Surveillance System Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHSN Surveillance System Codes**

## NamingSystem: NHSN Surveillance System Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDCNHSN | *Version*:3.0.0 | |
| Active as of 2021-03-24 | *Responsible:*[U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)](https://www.cdc.gov/nhsn) | *Computable Name*:CDCNHSN |

 
A set of healthcare surveillance vocabulary concepts and associated identifiers intended solely for data submissions to the National Healthcare Safety Network (NHSN). Other uses are not recommended. 
The CDCNHSN code system is highly specialized to meet the needs of NHSN surveillance reporting, is undergoing changes, and is not recommended for creating value sets to be used outside of NHSN. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CDCNHSN |
| Version | 3.0.0 |
| Name | CDCNHSN |
| Title | NHSN Surveillance System Codes |
| Status | active |
| Definition | A set of healthcare surveillance vocabulary concepts and associated identifiers intended solely for data submissions to the National Healthcare Safety Network (NHSN). Other uses are not recommended.The CDCNHSN code system is highly specialized to meet the needs of NHSN surveillance reporting, is undergoing changes, and is not recommended for creating value sets to be used outside of NHSN. |
| Publisher | U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN) |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.277
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/cdcnhsn.html
  * **Preferred**: true
  * **Period**: 2021-03-24 00:00:00+0000 --> (ongoing)
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/cdcNHSN
  * **Preferred**: false
  * **Period**: (?) --> 2021-03-24 00:00:00+0000

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDCNHSN",
  "url" : "http://terminology.hl7.org/NamingSystem/CDCNHSN",
  "version" : "3.0.0",
  "name" : "CDCNHSN",
  "title" : "NHSN Surveillance System Codes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-24T00:00:00-00:00",
  "publisher" : "U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)",
  "contact" : [
    {
      "name" : "U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)",
      "telecom" : [
        {
          "system" : "email",
          "value" : "nhsncda@cdc.gov"
        },
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/nhsn"
        }
      ]
    }
  ],
  "responsible" : "U.S. Centers for Disease Control and Prevention (CDC), National Healthcare Safety Network (NHSN)",
  "description" : "A set of healthcare surveillance vocabulary concepts and associated identifiers intended solely for data submissions to the National Healthcare Safety Network (NHSN). Other uses are not recommended.\r\n\r\nThe CDCNHSN code system is highly specialized to meet the needs of NHSN surveillance reporting, is undergoing changes, and is not recommended for creating value sets to be used outside of NHSN.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.277",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/cdcnhsn.html",
      "preferred" : true,
      "period" : {
        "start" : "2021-03-24T00:00:00-00:00"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/cdcNHSN",
      "preferred" : false,
      "period" : {
        "end" : "2021-03-24T00:00:00-00:00"
      }
    }
  ]
}

```
