# Clinical Care Classification System - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Clinical Care Classification System**

## NamingSystem: Clinical Care Classification System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CCC | *Version*:2.0.1 | |
| Active as of 2019-03-20 | *Responsible:*Virginia K. Saba | *Computable Name*:CCC |

 
Clinical Care Classification System (formerly Home Health Care Classification system) codes. The Clinical Care Classification (CCC) consists of two taxonomies: CCC of Nursing Diagnoses and CCC of Nursing Interventions both of which are classified by 21 Care Components. Each of these are classified by Care Components which provide a standardized framework for documenting patient care in hospitals, home health agencies, ambulatory care clinics, and other health care settings. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CCC |
| Version | 2.0.1 |
| Name | CCC |
| Title | Clinical Care Classification System |
| Status | active |
| Definition | Clinical Care Classification System (formerly Home Health Care Classification system) codes. The Clinical Care Classification (CCC) consists of two taxonomies: CCC of Nursing Diagnoses and CCC of Nursing Interventions both of which are classified by 21 Care Components. Each of these are classified by Care Components which provide a standardized framework for documenting patient care in hospitals, home health agencies, ambulatory care clinics, and other health care settings. |
| Publisher | Virginia K. Saba |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.236
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/CCC
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CCC",
  "url" : "http://terminology.hl7.org/NamingSystem/CCC",
  "version" : "2.0.1",
  "name" : "CCC",
  "title" : "Clinical Care Classification System",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Virginia K. Saba",
  "responsible" : "Virginia K. Saba",
  "description" : "Clinical Care Classification System (formerly Home Health Care Classification system) codes. The Clinical Care Classification (CCC) consists of two taxonomies: CCC of Nursing Diagnoses and CCC of Nursing Interventions both of which are classified by 21 Care Components. Each of these are classified by Care Components which provide a standardized framework for documenting patient care in hospitals, home health agencies, ambulatory care clinics, and other health care settings.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.236",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/CCC",
      "preferred" : true
    }
  ]
}

```
