# Using MED-RT with HL7 Standards - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* [**External Code Systems**](external_code_systems.md)
* **Using MED-RT with HL7 Standards**

## Using MED-RT with HL7 Standards

This page describes how to use MDC with HL7 Standards.

The [Medication Reference Terminology (MED-RT)](/MEDRT.md) replaced the [National Drug File Reference Terminology (NDF-RT)](/NDFRT.md) as of UMLS v17AB. NDF-RT is no longer being maintained.

### Using MED-RT with FHIR R5

#### Summary

| | |
| :--- | :--- |
| Source | Medication Reference Terminology - prepared by[Veterans Health Administration](http://www.va.gov/health/), and distributed as part of[UMLS](http://www.nlm.nih.gov/research/umls/)by the[NLM](http://www.nlm.nih.gov/)([direct link](https://www.nlm.nih.gov/research/umls/sourcereleasedocs/current/MED-RT/index.html)) |
| System | http://va.gov/terminology/medrt |
| Version | Use the date of the UMLS release as the version of MED-RT (if a version is desired). |
| Code | The NUI is used for the code value for an MED-RT concept |
| Display | The concept name should be used as the display. |
| Inactive | There are no codes that are inactive. |
| Subsumption | Subsumption testing is based on the Is-a relationship defined by MED-RT |
| Filter Properties | None are described yet. |

#### Usage Notes

The MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition.

The representation of the contents of MED-RT in a FHIR CodeSystem resource may contain all concepts defined as existing solely in MED-RT, and relationships between concepts defined within MED-RT, and between MED-RT concepts and a concept in an external code system. In addition, ConceptMap resource(s) will be needed in order to represent the relationships in MED-RT that exist between external code systems.

*Currently all references to external code systems in MED-RT are to a specific version of the external code system.*

For more information, see the NCI MED-RT [page](https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT).

#### Version Issues

MED-RT is released as part of UMLS. Therefore, each successive release has the date of the UMLS release as its version.

#### Copyright/License Issues

MED-RT has no copyright acknowledgement required. However, users must adhere to the UMLS license.

#### MED-RT Filter Properties

This section documents the property filters that can be used with the MED-RT code system in value set composition statements (ValueSet.compose).

##### By Subsumption

| | |
| :--- | :--- |
| Description | Select a set of concepts based on subsumption testing |
| Property Name | concept |
| Operations Allowed | is-a |
| Values Allowed | NUI |
| Comments | Includes all concepts that have a transitive is-a relationship with the concept Id provided in the value as an NUI (including the concept itself) |

#### MED-RT Implicit Value Sets

No need for implicit value sets identified yet.

