# Virtual Healthcare Delivery Method - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Virtual Healthcare Delivery Method**

## CodeSystem: Virtual Healthcare Delivery Method 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/virtual-healthcare-delivery-method | *Version*:1.0.0 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:VirtualHealthcareDeliveryMethod |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for virtual healthcare service delivery method. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VirtualHealthcareDeliveryMethod](ValueSet-virtual-healthcare-delivery-method.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "virtual-healthcare-delivery-method",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/virtual-healthcare-delivery-method",
  "version" : "1.0.0",
  "name" : "VirtualHealthcareDeliveryMethod",
  "title" : "Virtual Healthcare Delivery Method",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for virtual healthcare service delivery method.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/virtual-healthcare-delivery-method",
  "content" : "complete",
  "concept" : [
    {
      "code" : "phone",
      "display" : "Phone",
      "definition" : "Voice Telephone"
    },
    {
      "code" : "video",
      "display" : "Video Chat",
      "definition" : "Video Chat"
    },
    {
      "code" : "tdd",
      "display" : "TDD",
      "definition" : "Telecommunications Device for the Deaf"
    },
    {
      "code" : "sms",
      "display" : "SMS",
      "definition" : "Short Message Service Text Messaging"
    },
    {
      "code" : "app",
      "display" : "App",
      "definition" : "Mobile Application"
    },
    {
      "code" : "web",
      "display" : "Website",
      "definition" : "Website accessed through browser"
    }
  ]
}

```
