# VaccineManufacturer - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **VaccineManufacturer**

## CodeSystem: VaccineManufacturer 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-VaccineManufacturer | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:VaccineManufacturer |
| *Other Identifiers:*OID:2.16.840.1.113883.5.144 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The manufacturer of a vaccine. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VaccineManufacturer](ValueSet-v3-VaccineManufacturer.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-VaccineManufacturer",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-VaccineManufacturer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.144"
    }
  ],
  "version" : "3.0.0",
  "name" : "VaccineManufacturer",
  "title" : "VaccineManufacturer",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The manufacturer of a vaccine.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AB",
      "display" : "Abbott Laboratories (includes Ross Products Division)",
      "definition" : "Abbott Laboratories (includes Ross Products Division)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11125"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "Adams Laboratories",
      "definition" : "Adams Laboratories",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11126"
        }
      ]
    },
    {
      "code" : "ALP",
      "display" : "Alpha Therapeutic Corporation",
      "definition" : "Alpha Therapeutic Corporation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11127"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Armour [Inactive - use CEN]",
      "definition" : "Armour \\[Inactive-use CEN\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11128"
        }
      ]
    },
    {
      "code" : "AVI",
      "display" : "Aviron",
      "definition" : "Aviron",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11129"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Baxter Healthcare Corporation",
      "definition" : "Baxter Healthcare Corporation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11130"
        }
      ]
    },
    {
      "code" : "BAY",
      "display" : "Bayer Corporation (includes Miles, Inc. and Cutter Laboratories)",
      "definition" : "Bayer Corporation (includes Miles, Inc. and Cutter Laboratories)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11131"
        }
      ]
    },
    {
      "code" : "BP",
      "display" : "Berna Products [Inactive - use BPC]",
      "definition" : "Berna Products \\[Inactive-use BPC\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11132"
        }
      ]
    },
    {
      "code" : "BPC",
      "display" : "Berna Products Corporation (includes Swiss Serum and Vaccine Institute Berne)",
      "definition" : "Berna Products Corporation (includes Swiss Serum and Vaccine Institute Berne)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11133"
        }
      ]
    },
    {
      "code" : "CEN",
      "display" : "Centeon L.L.C. (includes Armour Pharmaceutical Company)",
      "definition" : "Centeon L.L.C. (includes Armour Pharmaceutical Company)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11134"
        }
      ]
    },
    {
      "code" : "CHI",
      "display" : "Chiron Corporation",
      "definition" : "Chiron Corporation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11135"
        }
      ]
    },
    {
      "code" : "CON",
      "display" : "Connaught [Inactive - use PMC]",
      "definition" : "Connaught \\[Inactive-use PMC\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11136"
        }
      ]
    },
    {
      "code" : "EVN",
      "display" : "Evans Medical Limited (an affiliate of Medeva Pharmaceuticals, Inc.)",
      "definition" : "Evans Medical Limited (an affiliate of Medeva Pharmaceuticals, Inc.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11137"
        }
      ]
    },
    {
      "code" : "GRE",
      "display" : "Greer Laboratories, Inc.",
      "definition" : "Greer Laboratories, Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11138"
        }
      ]
    },
    {
      "code" : "IAG",
      "display" : "Immuno International AG",
      "definition" : "Immuno International AG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11139"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Merieux [Inactive - use PMC]",
      "definition" : "Merieux \\[Inactive-use PMC\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11140"
        }
      ]
    },
    {
      "code" : "IUS",
      "display" : "Immuno-U.S., Inc.",
      "definition" : "Immuno-U.S., Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11141"
        }
      ]
    },
    {
      "code" : "JPN",
      "display" : "The Research Foundation for Microbial Diseases of Osaka University (BIKEN)",
      "definition" : "The Research Foundation for Microbial Diseases of Osaka University (BIKEN)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11142"
        }
      ]
    },
    {
      "code" : "KGC",
      "display" : "Korea Green Cross Corporation",
      "definition" : "Korea Green Cross Corporation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11143"
        }
      ]
    },
    {
      "code" : "LED",
      "display" : "Lederle [Inactive - use WAL]",
      "definition" : "Lederle \\[Inactive-use WAL\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11144"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Massachusetts Public Health Biologic Laboratories",
      "definition" : "Massachusetts Public Health Biologic Laboratories",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11145"
        }
      ]
    },
    {
      "code" : "MED",
      "display" : "MedImmune, Inc.",
      "definition" : "MedImmune, Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11146"
        }
      ]
    },
    {
      "code" : "MIL",
      "display" : "Miles [Inactive - use BAY]",
      "definition" : "Miles \\[Inactive-use BAY\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11147"
        }
      ]
    },
    {
      "code" : "MIP",
      "display" : "Bioport Corporation (formerly Michigan Biologic Products Institute)",
      "definition" : "Bioport Corporation (formerly Michigan Biologic Products Institute)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11148"
        }
      ]
    },
    {
      "code" : "MSD",
      "display" : "Merck and Co., Inc.",
      "definition" : "Merck & Co., Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11149"
        }
      ]
    },
    {
      "code" : "NAB",
      "display" : "NABI (formerly North American Biologicals, Inc.)",
      "definition" : "NABI (formerly North American Biologicals, Inc.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11150"
        }
      ]
    },
    {
      "code" : "NAV",
      "display" : "North American Vaccine, Inc.",
      "definition" : "North American Vaccine, Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11152"
        }
      ]
    },
    {
      "code" : "NOV",
      "display" : "Novartis Pharmaceutical Corporation (includes Ciba-Geigy Limited and Sandoz Limited)",
      "definition" : "Novartis Pharmaceutical Corporation (includes Ciba-Geigy Limited and Sandoz Limited)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11153"
        }
      ]
    },
    {
      "code" : "NYB",
      "display" : "New York Blood Center",
      "definition" : "New York Blood Center",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11151"
        }
      ]
    },
    {
      "code" : "ORT",
      "display" : "Ortho Diagnostic Systems, Inc.",
      "definition" : "Ortho Diagnostic Systems, Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11155"
        }
      ]
    },
    {
      "code" : "OTC",
      "display" : "Organon Teknika Corporation",
      "definition" : "Organon Teknika Corporation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11154"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Parkedale Pharmaceuticals (formerly Parke-Davis)",
      "definition" : "Parkedale Pharmaceuticals (formerly Parke-Davis)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11156"
        }
      ]
    },
    {
      "code" : "PMC",
      "display" : "Aventis Pasteur Inc. (formerly Pasteur Merieux Connaught; includes Connaught Laboratories and Pasteur Merieux)",
      "definition" : "Aventis Pasteur Inc. (formerly Pasteur Merieux Connaught; includes Connaught Laboratories and Pasteur Merieux)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11157"
        }
      ]
    },
    {
      "code" : "PRX",
      "display" : "Praxis Biologics [Inactive - use WAL]",
      "definition" : "Praxis Biologics \\[Inactive-use WAL\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11158"
        }
      ]
    },
    {
      "code" : "SCL",
      "display" : "Sclavo, Inc.",
      "definition" : "Sclavo, Inc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11159"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Swiss Serum and Vaccine Inst. [Inactive - use BPC]",
      "definition" : "Swiss Serum and Vaccine Inst. \\[Inactive-use BPC\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11160"
        }
      ]
    },
    {
      "code" : "SKB",
      "display" : "SmithKline Beecham",
      "definition" : "SmithKline Beecham",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11161"
        }
      ]
    },
    {
      "code" : "USA",
      "display" : "United States Army Medical Research and Materiel Command",
      "definition" : "United States Army Medical Research and Materiel Command",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11162"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wyeth-Ayerst [Inactive - use WAL]",
      "definition" : "Wyeth-Ayerst \\[Inactive-use WAL\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11163"
        }
      ]
    },
    {
      "code" : "WAL",
      "display" : "Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle Laboratories, and Praxis Biologics)",
      "definition" : "Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle Laboratories, and Praxis Biologics)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11164"
        }
      ]
    }
  ]
}

```
