# RouteOfAdministration - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RouteOfAdministration**

## CodeSystem: RouteOfAdministration 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RouteOfAdministration |
| *Other Identifiers:*OID:2.16.840.1.113883.5.112 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The path the administered medication takes to get into the body or into contact with the body. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AmnioticFluidSacRoute](ValueSet-v3-AmnioticFluidSacRoute.md)
* [BiliaryRoute](ValueSet-v3-BiliaryRoute.md)
* [BodySurfaceRoute](ValueSet-v3-BodySurfaceRoute.md)
* [BuccalMucosaRoute](ValueSet-v3-BuccalMucosaRoute.md)
* [CecostomyRoute](ValueSet-v3-CecostomyRoute.md)
* [CervicalRoute](ValueSet-v3-CervicalRoute.md)
* [Chew](ValueSet-v3-Chew.md)
* [Diffusion](ValueSet-v3-Diffusion.md)
* [Dissolve](ValueSet-v3-Dissolve.md)
* [Douche](ValueSet-v3-Douche.md)
* [ElectroOsmosisRoute](ValueSet-v3-ElectroOsmosisRoute.md)
* [EndocervicalRoute](ValueSet-v3-EndocervicalRoute.md)
* [Enema](ValueSet-v3-Enema.md)
* [EnteralRoute](ValueSet-v3-EnteralRoute.md)
* [EpiduralRoute](ValueSet-v3-EpiduralRoute.md)
* [ExtraAmnioticRoute](ValueSet-v3-ExtraAmnioticRoute.md)
* [ExtracorporealCirculationRoute](ValueSet-v3-ExtracorporealCirculationRoute.md)
* [Flush](ValueSet-v3-Flush.md)
* [GastricRoute](ValueSet-v3-GastricRoute.md)
* [GenitourinaryRoute](ValueSet-v3-GenitourinaryRoute.md)
* [GingivalRoute](ValueSet-v3-GingivalRoute.md)
* [HairRoute](ValueSet-v3-HairRoute.md)
* [Implantation](ValueSet-v3-Implantation.md)
* [Infusion](ValueSet-v3-Infusion.md)
* [Inhalation](ValueSet-v3-Inhalation.md)
* [Injection](ValueSet-v3-Injection.md)
* [Insertion](ValueSet-v3-Insertion.md)
* [Instillation](ValueSet-v3-Instillation.md)
* [InterameningealRoute](ValueSet-v3-InterameningealRoute.md)
* [InterstitialRoute](ValueSet-v3-InterstitialRoute.md)
* [IntraabdominalRoute](ValueSet-v3-IntraabdominalRoute.md)
* [IntraarterialInjection](ValueSet-v3-IntraarterialInjection.md)
* [IntraarterialRoute](ValueSet-v3-IntraarterialRoute.md)
* [IntraarticularRoute](ValueSet-v3-IntraarticularRoute.md)
* [IntrabronchialRoute](ValueSet-v3-IntrabronchialRoute.md)
* [IntrabursalRoute](ValueSet-v3-IntrabursalRoute.md)
* [IntracardiacInjection](ValueSet-v3-IntracardiacInjection.md)
* [IntracardiacRoute](ValueSet-v3-IntracardiacRoute.md)
* [IntracartilaginousRoute](ValueSet-v3-IntracartilaginousRoute.md)
* [IntracaudalRoute](ValueSet-v3-IntracaudalRoute.md)
* [IntracavernosalRoute](ValueSet-v3-IntracavernosalRoute.md)
* [IntracavitaryRoute](ValueSet-v3-IntracavitaryRoute.md)
* [IntracerebralRoute](ValueSet-v3-IntracerebralRoute.md)
* [IntracervicalRoute](ValueSet-v3-IntracervicalRoute.md)
* [IntracisternalRoute](ValueSet-v3-IntracisternalRoute.md)
* [IntracornealRoute](ValueSet-v3-IntracornealRoute.md)
* [IntracoronalRoute](ValueSet-v3-IntracoronalRoute.md)
* [IntracoronaryInjection](ValueSet-v3-IntracoronaryInjection.md)
* [IntracoronaryRoute](ValueSet-v3-IntracoronaryRoute.md)
* [IntracorpusCavernosumRoute](ValueSet-v3-IntracorpusCavernosumRoute.md)
* [IntradermalRoute](ValueSet-v3-IntradermalRoute.md)
* [IntradiscalRoute](ValueSet-v3-IntradiscalRoute.md)
* [IntraductalRoute](ValueSet-v3-IntraductalRoute.md)
* [IntraduodenalRoute](ValueSet-v3-IntraduodenalRoute.md)
* [IntraduralRoute](ValueSet-v3-IntraduralRoute.md)
* [IntraepidermalRoute](ValueSet-v3-IntraepidermalRoute.md)
* [IntraepithelialRoute](ValueSet-v3-IntraepithelialRoute.md)
* [IntraesophagealRoute](ValueSet-v3-IntraesophagealRoute.md)
* [IntragastricRoute](ValueSet-v3-IntragastricRoute.md)
* [IntrailealRoute](ValueSet-v3-IntrailealRoute.md)
* [IntralesionalRoute](ValueSet-v3-IntralesionalRoute.md)
* [IntraluminalRoute](ValueSet-v3-IntraluminalRoute.md)
* [IntralymphaticRoute](ValueSet-v3-IntralymphaticRoute.md)
* [IntramedullaryRoute](ValueSet-v3-IntramedullaryRoute.md)
* [IntramuscularInjection](ValueSet-v3-IntramuscularInjection.md)
* [IntramuscularRoute](ValueSet-v3-IntramuscularRoute.md)
* [IntraocularRoute](ValueSet-v3-IntraocularRoute.md)
* [IntraosseousRoute](ValueSet-v3-IntraosseousRoute.md)
* [IntraovarianRoute](ValueSet-v3-IntraovarianRoute.md)
* [IntrapericardialRoute](ValueSet-v3-IntrapericardialRoute.md)
* [IntraperitonealRoute](ValueSet-v3-IntraperitonealRoute.md)
* [IntrapleuralRoute](ValueSet-v3-IntrapleuralRoute.md)
* [IntraprostaticRoute](ValueSet-v3-IntraprostaticRoute.md)
* [IntrapulmonaryRoute](ValueSet-v3-IntrapulmonaryRoute.md)
* [IntrasinalRoute](ValueSet-v3-IntrasinalRoute.md)
* [IntraspinalRoute](ValueSet-v3-IntraspinalRoute.md)
* [IntrasternalRoute](ValueSet-v3-IntrasternalRoute.md)
* [IntrasynovialRoute](ValueSet-v3-IntrasynovialRoute.md)
* [IntratendinousRoute](ValueSet-v3-IntratendinousRoute.md)
* [IntratesticularRoute](ValueSet-v3-IntratesticularRoute.md)
* [IntrathecalRoute](ValueSet-v3-IntrathecalRoute.md)
* [IntrathoracicRoute](ValueSet-v3-IntrathoracicRoute.md)
* [IntratrachealRoute](ValueSet-v3-IntratrachealRoute.md)
* [IntratubularRoute](ValueSet-v3-IntratubularRoute.md)
* [IntratumorRoute](ValueSet-v3-IntratumorRoute.md)
* [IntratympanicRoute](ValueSet-v3-IntratympanicRoute.md)
* [IntrauterineRoute](ValueSet-v3-IntrauterineRoute.md)
* [IntravascularRoute](ValueSet-v3-IntravascularRoute.md)
* [IntravenousInfusion](ValueSet-v3-IntravenousInfusion.md)
* [IntravenousInjection](ValueSet-v3-IntravenousInjection.md)
* [IntravenousRoute](ValueSet-v3-IntravenousRoute.md)
* [IntraventricularRoute](ValueSet-v3-IntraventricularRoute.md)
* [IntravesicleRoute](ValueSet-v3-IntravesicleRoute.md)
* [IntravitrealRoute](ValueSet-v3-IntravitrealRoute.md)
* [IontophoresisRoute](ValueSet-v3-IontophoresisRoute.md)
* [Irrigation](ValueSet-v3-Irrigation.md)
* [JejunumRoute](ValueSet-v3-JejunumRoute.md)
* [LacrimalPunctaRoute](ValueSet-v3-LacrimalPunctaRoute.md)
* [LaryngealRoute](ValueSet-v3-LaryngealRoute.md)
* [LavageRoute](ValueSet-v3-LavageRoute.md)
* [LingualRoute](ValueSet-v3-LingualRoute.md)
* [MucosalAbsorptionRoute](ValueSet-v3-MucosalAbsorptionRoute.md)
* [MucousMembraneRoute](ValueSet-v3-MucousMembraneRoute.md)
* [NailRoute](ValueSet-v3-NailRoute.md)
* [NasalInhalation](ValueSet-v3-NasalInhalation.md)
* [NasalRoute](ValueSet-v3-NasalRoute.md)
* [Nebulization](ValueSet-v3-Nebulization.md)
* [NebulizationInhalation](ValueSet-v3-NebulizationInhalation.md)
* [OphthalmicRoute](ValueSet-v3-OphthalmicRoute.md)
* [OralInhalation](ValueSet-v3-OralInhalation.md)
* [OralRoute](ValueSet-v3-OralRoute.md)
* [OromucosalRoute](ValueSet-v3-OromucosalRoute.md)
* [OropharyngealRoute](ValueSet-v3-OropharyngealRoute.md)
* [OticRoute](ValueSet-v3-OticRoute.md)
* [ParanasalSinusesRoute](ValueSet-v3-ParanasalSinusesRoute.md)
* [ParenteralRoute](ValueSet-v3-ParenteralRoute.md)
* [PerianalRoute](ValueSet-v3-PerianalRoute.md)
* [PeriarticularRoute](ValueSet-v3-PeriarticularRoute.md)
* [PeriduralRoute](ValueSet-v3-PeriduralRoute.md)
* [PerinealRoute](ValueSet-v3-PerinealRoute.md)
* [PerineuralRoute](ValueSet-v3-PerineuralRoute.md)
* [PeriodontalRoute](ValueSet-v3-PeriodontalRoute.md)
* [PulmonaryRoute](ValueSet-v3-PulmonaryRoute.md)
* [RectalInstillation](ValueSet-v3-RectalInstillation.md)
* [RectalRoute](ValueSet-v3-RectalRoute.md)
* [RespiratoryTractRoute](ValueSet-v3-RespiratoryTractRoute.md)
* [RetrobulbarRoute](ValueSet-v3-RetrobulbarRoute.md)
* [Rinse](ValueSet-v3-Rinse.md)
* [RouteByMethod](ValueSet-v3-RouteByMethod.md)
* [RouteBySite](ValueSet-v3-RouteBySite.md)
* [RouteOfAdministration](ValueSet-v3-RouteOfAdministration.md)
* [ScalpRoute](ValueSet-v3-ScalpRoute.md)
* [SinusUnspecifiedRoute](ValueSet-v3-SinusUnspecifiedRoute.md)
* [SkinRoute](ValueSet-v3-SkinRoute.md)
* [SoftTissueRoute](ValueSet-v3-SoftTissueRoute.md)
* [SubarachnoidRoute](ValueSet-v3-SubarachnoidRoute.md)
* [SubconjunctivalRoute](ValueSet-v3-SubconjunctivalRoute.md)
* [SubcutaneousRoute](ValueSet-v3-SubcutaneousRoute.md)
* [SublesionalRoute](ValueSet-v3-SublesionalRoute.md)
* [SublingualRoute](ValueSet-v3-SublingualRoute.md)
* [SubmucosalRoute](ValueSet-v3-SubmucosalRoute.md)
* [SuppositoryRoute](ValueSet-v3-SuppositoryRoute.md)
* [Swish](ValueSet-v3-Swish.md)
* [TopicalAbsorptionRoute](ValueSet-v3-TopicalAbsorptionRoute.md)
* [TopicalApplication](ValueSet-v3-TopicalApplication.md)
* [TracheostomyRoute](ValueSet-v3-TracheostomyRoute.md)
* [Transdermal](ValueSet-v3-Transdermal.md)
* [TransmucosalRoute](ValueSet-v3-TransmucosalRoute.md)
* [TransplacentalRoute](ValueSet-v3-TransplacentalRoute.md)
* [TranstrachealRoute](ValueSet-v3-TranstrachealRoute.md)
* [TranstympanicRoute](ValueSet-v3-TranstympanicRoute.md)
* [UreteralRoute](ValueSet-v3-UreteralRoute.md)
* [UrethralRoute](ValueSet-v3-UrethralRoute.md)
* [UrinaryBladderIrrigation](ValueSet-v3-UrinaryBladderIrrigation.md)
* [UrinaryBladderRoute](ValueSet-v3-UrinaryBladderRoute.md)
* [UrinaryTractRoute](ValueSet-v3-UrinaryTractRoute.md)
* [VaginalRoute](ValueSet-v3-VaginalRoute.md)
* [VitreousHumourRoute](ValueSet-v3-VitreousHumourRoute.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RouteOfAdministration",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.112"
    }
  ],
  "version" : "3.0.0",
  "name" : "RouteOfAdministration",
  "title" : "RouteOfAdministration",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The path the administered medication takes to get into the body or into contact with the body.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_RouteByMethod",
      "display" : "RouteByMethod",
      "definition" : "Route of substance administration classified by administration method.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21256"
        }
      ]
    },
    {
      "code" : "_RouteBySite",
      "display" : "RouteBySite",
      "definition" : "Route of substance administration classified by site.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21257"
        }
      ]
    },
    {
      "code" : "AMNINJ",
      "display" : "Injection, amniotic fluid",
      "definition" : "Injection, amniotic fluid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14629"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AmnioticFluidSacRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EndocervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "BILINJ",
      "display" : "Injection, biliary tract",
      "definition" : "Injection, biliary tract",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14630"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BiliaryRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EndocervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "CHOLINJ",
      "display" : "Injection, for cholangiography",
      "definition" : "Injection, for cholangiography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14634"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BiliaryRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "DRESS",
      "display" : "Topical application, soaked dressing",
      "definition" : "Topical application, soaked dressing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14756"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ELECTOSMOS",
      "display" : "Electro-osmosis",
      "definition" : "Electro-osmosis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16932"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ElectroOsmosisRoute"
        }
      ]
    },
    {
      "code" : "IONTO",
      "display" : "Topical application, iontophoresis",
      "definition" : "Topical application, iontophoresis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16991"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IontophoresisRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "SOAK",
      "display" : "Immersion (soak)",
      "definition" : "Immersion (soak)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14597"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "SWAB",
      "display" : "Topical application, swab",
      "definition" : "Topical application, swab",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14757"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "TOPICAL",
      "display" : "Topical",
      "definition" : "Topical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17005"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BodySurfaceRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "BUC",
      "display" : "Topical application, buccal",
      "definition" : "Topical application, buccal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14740"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_BuccalMucosaRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "CECINSTL",
      "display" : "Instillation, cecostomy",
      "definition" : "Instillation, cecostomy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14697"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CecostomyRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "CERV",
      "display" : "Topical application, cervical",
      "definition" : "Topical application, cervical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14741"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "CERVINJ",
      "display" : "Injection, cervical",
      "definition" : "Injection, cervical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14631"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "CERVINS",
      "display" : "Insertion, cervical (uterine)",
      "definition" : "Insertion, cervical (uterine)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14688"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        }
      ]
    },
    {
      "code" : "DEN",
      "display" : "Topical application, dental",
      "definition" : "Topical application, dental",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14742"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "DENRINSE",
      "display" : "Rinse, dental",
      "definition" : "Rinse, dental",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14731"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CervicalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Rinse"
        }
      ]
    },
    {
      "code" : "CHEW",
      "display" : "Chew, oral",
      "definition" : "Chew, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14583"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Chew"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        }
      ]
    },
    {
      "code" : "EXTCORPDIF",
      "display" : "Diffusion, extracorporeal",
      "definition" : "Diffusion, extracorporeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19401"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Diffusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ExtracorporealCirculationRoute"
        }
      ]
    },
    {
      "code" : "HEMODIFF",
      "display" : "Diffusion, hemodialysis",
      "definition" : "Diffusion, hemodialysis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14585"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Diffusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravascularRoute"
        }
      ]
    },
    {
      "code" : "TRNSDERMD",
      "display" : "Diffusion, transdermal",
      "definition" : "Diffusion, transdermal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14759"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Diffusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TRNSDERM"
        }
      ]
    },
    {
      "code" : "DISSOLVE",
      "display" : "Dissolve, oral",
      "definition" : "Dissolve, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14587"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Dissolve"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        }
      ]
    },
    {
      "code" : "SL",
      "display" : "Dissolve, sublingual",
      "definition" : "Dissolve, sublingual",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14588"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Dissolve"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SublingualRoute"
        }
      ]
    },
    {
      "code" : "DOUCHE",
      "display" : "Douche, vaginal",
      "definition" : "Douche, vaginal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14590"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Douche"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_VaginalRoute"
        }
      ]
    },
    {
      "code" : "ENEMA",
      "display" : "Enema, rectal",
      "definition" : "Enema, rectal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14592"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Enema"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        }
      ]
    },
    {
      "code" : "RETENEMA",
      "display" : "Enema, rectal retention",
      "definition" : "Enema, rectal retention",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14593"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Enema"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        }
      ]
    },
    {
      "code" : "EFT",
      "display" : "Instillation, enteral feeding tube",
      "definition" : "Instillation, enteral feeding tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14702"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EnteralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "ENTINSTL",
      "display" : "Instillation, enteral",
      "definition" : "Instillation, enteral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14701"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EnteralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "EPI",
      "display" : "Infusion, epidural",
      "definition" : "Infusion, epidural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14603"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EpiduralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        }
      ]
    },
    {
      "code" : "EPIDURINJ",
      "display" : "Injection, epidural",
      "definition" : "Injection, epidural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16940"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EpiduralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "EPIINJ",
      "display" : "Injection, epidural, push",
      "definition" : "Injection, epidural, push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14632"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EpiduralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "EPINJSP",
      "display" : "Injection, epidural, slow push",
      "definition" : "Injection, epidural, slow push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14633"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EpiduralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "EXTRAMNINJ",
      "display" : "Injection, extra-amniotic",
      "definition" : "Injection, extra-amniotic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16941"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ExtraAmnioticRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "EXTCORPINJ",
      "display" : "Injection, extracorporeal",
      "definition" : "Injection, extracorporeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19400"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ExtracorporealCirculationRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrapulmonaryRoute"
        }
      ]
    },
    {
      "code" : "IVFLUSH",
      "display" : "Flush, intravenous catheter",
      "definition" : "Flush, intravenous catheter",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14595"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Flush"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravenousRoute"
        }
      ]
    },
    {
      "code" : "GBINJ",
      "display" : "Injection, gastric button",
      "definition" : "Injection, gastric button",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14635"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "GT",
      "display" : "Instillation, gastrostomy tube",
      "definition" : "Instillation, gastrostomy tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14704"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "NGT",
      "display" : "Instillation, nasogastric tube",
      "definition" : "Instillation, nasogastric tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14708"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "OGT",
      "display" : "Instillation, orogastric tube",
      "definition" : "Instillation, orogastric tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14710"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        }
      ]
    },
    {
      "code" : "GUIRR",
      "display" : "Irrigation, genitourinary",
      "definition" : "Irrigation, genitourinary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14722"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenitourinaryRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        }
      ]
    },
    {
      "code" : "GIN",
      "display" : "Topical application, gingival",
      "definition" : "Topical application, gingival",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14743"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GingivalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "GINGINJ",
      "display" : "Injection, gingival",
      "definition" : "Injection, gingival",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14636"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GingivalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        }
      ]
    },
    {
      "code" : "HAIR",
      "display" : "Topical application, hair",
      "definition" : "Topical application, hair",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14744"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_HairRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "SHAMPOO",
      "display" : "Shampoo",
      "definition" : "Shampoo",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14733"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_HairRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "IDIMPLNT",
      "display" : "Implantation, intradermal",
      "definition" : "Implantation, intradermal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14599"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Implantation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntradermalRoute"
        }
      ]
    },
    {
      "code" : "IVITIMPLNT",
      "display" : "Implantation, intravitreal",
      "definition" : "Implantation, intravitreal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14600"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Implantation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_VitreousHumourRoute"
        }
      ]
    },
    {
      "code" : "SQIMPLNT",
      "display" : "Implantation, subcutaneous",
      "definition" : "Implantation, subcutaneous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14601"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Implantation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubcutaneousRoute"
        }
      ]
    },
    {
      "code" : "IA",
      "display" : "Infusion, intraarterial catheter",
      "definition" : "Infusion, intraarterial catheter",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14604"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraarterialRoute"
        }
      ]
    },
    {
      "code" : "IC",
      "display" : "Infusion, intracardiac",
      "definition" : "Infusion, intracardiac",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14605"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracardiacRoute"
        }
      ]
    },
    {
      "code" : "ICOR",
      "display" : "Infusion, intracoronary",
      "definition" : "Infusion, intracoronary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14606"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracoronaryRoute"
        }
      ]
    },
    {
      "code" : "IOSSC",
      "display" : "Infusion, intraosseous, continuous",
      "definition" : "Infusion, intraosseous, continuous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14607"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraosseousRoute"
        }
      ]
    },
    {
      "code" : "IT",
      "display" : "Infusion, intrathecal",
      "definition" : "Infusion, intrathecal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14608"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrathecalRoute"
        }
      ]
    },
    {
      "code" : "IV",
      "display" : "Infusion, intravenous",
      "definition" : "Infusion, intravenous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14609"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        }
      ]
    },
    {
      "code" : "IVASCINFUS",
      "display" : "Infusion, intravascular",
      "definition" : "Infusion, intravascular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16936"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravascularRoute"
        }
      ]
    },
    {
      "code" : "SQINFUS",
      "display" : "Infusion, subcutaneous",
      "definition" : "Infusion, subcutaneous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14614"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Infusion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubcutaneousRoute"
        }
      ]
    },
    {
      "code" : "IPINHL",
      "display" : "Inhalation, respiratory",
      "definition" : "Inhalation, oral",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, intrapulmonary"
        },
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, oral"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "ORINHL"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "RESPINHL"
        },
        {
          "code" : "internalId",
          "valueCode" : "14622"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RespiratoryTractRoute"
        }
      ]
    },
    {
      "code" : "ORINHL",
      "display" : "Inhalation, respiratory",
      "definition" : "Inhalation, oral",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, intrapulmonary"
        },
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, oral"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "IPINHL"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "RESPINHL"
        },
        {
          "code" : "internalId",
          "valueCode" : "14622"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RespiratoryTractRoute"
        }
      ]
    },
    {
      "code" : "RESPINHL",
      "display" : "Inhalation, respiratory",
      "definition" : "Inhalation, oral",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, intrapulmonary"
        },
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, oral"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "IPINHL"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "ORINHL"
        },
        {
          "code" : "internalId",
          "valueCode" : "14622"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RespiratoryTractRoute"
        }
      ]
    },
    {
      "code" : "IPPB",
      "display" : "Inhalation, intermittent positive pressure breathing (ippb)",
      "definition" : "Inhalation, intermittent positive pressure breathing (ippb)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14616"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "NASINHL",
      "display" : "Inhalation, nasal",
      "definition" : "Inhalation, nasal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14617"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_NasalRoute"
        }
      ]
    },
    {
      "code" : "NEB",
      "display" : "Inhalation, nebulization",
      "definition" : "Inhalation, nebulization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14619"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        }
      ]
    },
    {
      "code" : "TRACH",
      "display" : "Inhalation, tracheostomy",
      "definition" : "Inhalation, tracheostomy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14625"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TracheostomyRoute"
        }
      ]
    },
    {
      "code" : "VENT",
      "display" : "Inhalation, ventilator",
      "definition" : "Inhalation, ventilator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14626"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "VENTMASK",
      "display" : "Inhalation, ventimask",
      "definition" : "Inhalation, ventimask",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14627"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Inhalation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "BLADINJ",
      "display" : "Injection, urinary bladder",
      "definition" : "Injection, urinary bladder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14686"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrinaryBladderRoute"
        }
      ]
    },
    {
      "code" : "ENDOSININJ",
      "display" : "Injection, endosinusial",
      "definition" : "Injection, endosinusial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16939"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SinusUnspecifiedRoute"
        }
      ]
    },
    {
      "code" : "HEMOPORT",
      "display" : "Injection, hemodialysis port",
      "definition" : "Injection, hemodialysis port",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14637"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravascularRoute"
        }
      ]
    },
    {
      "code" : "IABDINJ",
      "display" : "Injection, intra-abdominal",
      "definition" : "Injection, intra-abdominal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16944"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraabdominalRoute"
        }
      ]
    },
    {
      "code" : "IAINJ",
      "display" : "Injection, intraarterial",
      "definition" : "Injection, intraarterial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14639"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraarterialRoute"
        }
      ]
    },
    {
      "code" : "IARTINJ",
      "display" : "Injection, intraarticular",
      "definition" : "Injection, intraarticular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14642"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraarticularRoute"
        }
      ]
    },
    {
      "code" : "IBURSINJ",
      "display" : "Injection, intrabursal",
      "definition" : "Injection, intrabursal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14643"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrabursalRoute"
        }
      ]
    },
    {
      "code" : "ICARDINJ",
      "display" : "Injection, intracardiac",
      "definition" : "Injection, intracardiac",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14644"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracardiacRoute"
        }
      ]
    },
    {
      "code" : "ICARTINJ",
      "display" : "Injection, intracartilaginous",
      "definition" : "Injection, intracartilaginous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16945"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracartilaginousRoute"
        }
      ]
    },
    {
      "code" : "ICAUDINJ",
      "display" : "Injection, intracaudal",
      "definition" : "Injection, intracaudal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16946"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracaudalRoute"
        }
      ]
    },
    {
      "code" : "ICAVINJ",
      "display" : "Injection, intracavernous",
      "definition" : "Injection, intracavernous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14648"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracavernosalRoute"
        }
      ]
    },
    {
      "code" : "ICAVITINJ",
      "display" : "Injection, intracavitary",
      "definition" : "Injection, intracavitary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16947"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracavitaryRoute"
        }
      ]
    },
    {
      "code" : "ICEREBINJ",
      "display" : "Injection, intracerebral",
      "definition" : "Injection, intracerebral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16948"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracerebralRoute"
        }
      ]
    },
    {
      "code" : "ICISTERNINJ",
      "display" : "Injection, intracisternal",
      "definition" : "Injection, intracisternal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16949"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracisternalRoute"
        }
      ]
    },
    {
      "code" : "ICORONINJ",
      "display" : "Injection, intracoronary",
      "definition" : "Injection, intracoronary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14650"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracoronaryRoute"
        }
      ]
    },
    {
      "code" : "ICORPCAVINJ",
      "display" : "Injection, intracorpus cavernosum",
      "definition" : "Injection, intracorpus cavernosum",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16950"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracorpusCavernosumRoute"
        }
      ]
    },
    {
      "code" : "IDINJ",
      "display" : "Injection, intradermal",
      "definition" : "Injection, intradermal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14652"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntradermalRoute"
        }
      ]
    },
    {
      "code" : "IDISCINJ",
      "display" : "Injection, intradiscal",
      "definition" : "Injection, intradiscal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14653"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntradiscalRoute"
        }
      ]
    },
    {
      "code" : "IDUCTINJ",
      "display" : "Injection, intraductal",
      "definition" : "Injection, intraductal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16951"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraductalRoute"
        }
      ]
    },
    {
      "code" : "IDURINJ",
      "display" : "Injection, intradural",
      "definition" : "Injection, intradural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16952"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraduralRoute"
        }
      ]
    },
    {
      "code" : "IEPIDINJ",
      "display" : "Injection, intraepidermal",
      "definition" : "Injection, intraepidermal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16953"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraepidermalRoute"
        }
      ]
    },
    {
      "code" : "IEPITHINJ",
      "display" : "Injection, intraepithelial",
      "definition" : "Injection, intraepithelial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14654"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraepithelialRoute"
        }
      ]
    },
    {
      "code" : "ILESINJ",
      "display" : "Injection, intralesional",
      "definition" : "Injection, intralesional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14655"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntralesionalRoute"
        }
      ]
    },
    {
      "code" : "ILUMINJ",
      "display" : "Injection, intraluminal",
      "definition" : "Injection, intraluminal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16954"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraluminalRoute"
        }
      ]
    },
    {
      "code" : "ILYMPJINJ",
      "display" : "Injection, intralymphatic",
      "definition" : "Injection, intralymphatic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14656"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntralymphaticRoute"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Injection, intramuscular",
      "definition" : "Injection, intramuscular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14657"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntramuscularRoute"
        }
      ]
    },
    {
      "code" : "IMEDULINJ",
      "display" : "Injection, intramedullary",
      "definition" : "Injection, intramedullary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16955"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntramedullaryRoute"
        }
      ]
    },
    {
      "code" : "INTERMENINJ",
      "display" : "Injection, interameningeal",
      "definition" : "Injection, interameningeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16942"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_InterameningealRoute"
        }
      ]
    },
    {
      "code" : "INTERSTITINJ",
      "display" : "Injection, interstitial",
      "definition" : "Injection, interstitial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16943"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_InterstitialRoute"
        }
      ]
    },
    {
      "code" : "IOINJ",
      "display" : "Injection, intraocular",
      "definition" : "Injection, intraocular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14660"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraocularRoute"
        }
      ]
    },
    {
      "code" : "IOSSINJ",
      "display" : "Injection, intraosseous",
      "definition" : "Injection, intraosseous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14661"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraosseousRoute"
        }
      ]
    },
    {
      "code" : "IOVARINJ",
      "display" : "Injection, intraovarian",
      "definition" : "Injection, intraovarian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16956"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraovarianRoute"
        }
      ]
    },
    {
      "code" : "IPCARDINJ",
      "display" : "Injection, intrapericardial",
      "definition" : "Injection, intrapericardial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16957"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrapericardialRoute"
        }
      ]
    },
    {
      "code" : "IPERINJ",
      "display" : "Injection, intraperitoneal",
      "definition" : "Injection, intraperitoneal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14662"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraperitonealRoute"
        }
      ]
    },
    {
      "code" : "IPINJ",
      "display" : "Injection, intrapulmonary",
      "definition" : "Injection, intrapulmonary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16959"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrapulmonaryRoute"
        }
      ]
    },
    {
      "code" : "IPLRINJ",
      "display" : "Injection, intrapleural",
      "definition" : "Injection, intrapleural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14663"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrapleuralRoute"
        }
      ]
    },
    {
      "code" : "IPROSTINJ",
      "display" : "Injection, intraprostatic",
      "definition" : "Injection, intraprostatic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16958"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraprostaticRoute"
        }
      ]
    },
    {
      "code" : "IPUMPINJ",
      "display" : "Injection, insulin pump",
      "definition" : "Injection, insulin pump",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14638"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubcutaneousRoute"
        }
      ]
    },
    {
      "code" : "ISINJ",
      "display" : "Injection, intraspinal",
      "definition" : "Injection, intraspinal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14664"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraspinalRoute"
        }
      ]
    },
    {
      "code" : "ISTERINJ",
      "display" : "Injection, intrasternal",
      "definition" : "Injection, intrasternal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14665"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrasternalRoute"
        }
      ]
    },
    {
      "code" : "ISYNINJ",
      "display" : "Injection, intrasynovial",
      "definition" : "Injection, intrasynovial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14666"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrasynovialRoute"
        }
      ]
    },
    {
      "code" : "ITENDINJ",
      "display" : "Injection, intratendinous",
      "definition" : "Injection, intratendinous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16960"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratendinousRoute"
        }
      ]
    },
    {
      "code" : "ITESTINJ",
      "display" : "Injection, intratesticular",
      "definition" : "Injection, intratesticular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16961"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratesticularRoute"
        }
      ]
    },
    {
      "code" : "ITHORINJ",
      "display" : "Injection, intrathoracic",
      "definition" : "Injection, intrathoracic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16962"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrathoracicRoute"
        }
      ]
    },
    {
      "code" : "ITINJ",
      "display" : "Injection, intrathecal",
      "definition" : "Injection, intrathecal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14667"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrathecalRoute"
        }
      ]
    },
    {
      "code" : "ITUBINJ",
      "display" : "Injection, intratubular",
      "definition" : "Injection, intratubular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16963"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratubularRoute"
        }
      ]
    },
    {
      "code" : "ITUMINJ",
      "display" : "Injection, intratumor",
      "definition" : "Injection, intratumor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16964"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratumorRoute"
        }
      ]
    },
    {
      "code" : "ITYMPINJ",
      "display" : "Injection, intratympanic",
      "definition" : "Injection, intratympanic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16965"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratympanicRoute"
        }
      ]
    },
    {
      "code" : "IUINJ",
      "display" : "Injection, intrauterine",
      "definition" : "Injection, intracervical (uterus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14669"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrauterineRoute"
        }
      ]
    },
    {
      "code" : "IUINJC",
      "display" : "Injection, intracervical (uterus)",
      "definition" : "Injection, intracervical (uterus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14649"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracervicalRoute"
        }
      ]
    },
    {
      "code" : "IURETINJ",
      "display" : "Injection, intraureteral, retrograde",
      "definition" : "Injection, intraureteral, retrograde",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14668"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrauterineRoute"
        }
      ]
    },
    {
      "code" : "IVASCINJ",
      "display" : "Injection, intravascular",
      "definition" : "Injection, intravascular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16966"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravascularRoute"
        }
      ]
    },
    {
      "code" : "IVENTINJ",
      "display" : "Injection, intraventricular (heart)",
      "definition" : "Injection, intraventricular (heart)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14675"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraventricularRoute"
        }
      ]
    },
    {
      "code" : "IVESINJ",
      "display" : "Injection, intravesicle",
      "definition" : "Injection, intravesicle",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14676"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravesicleRoute"
        }
      ]
    },
    {
      "code" : "IVINJ",
      "display" : "Injection, intravenous",
      "definition" : "Injection, intravenous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14670"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravenousRoute"
        }
      ]
    },
    {
      "code" : "IVITINJ",
      "display" : "Injection, intravitreal",
      "definition" : "Injection, intravitreal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14677"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntravitrealRoute"
        }
      ]
    },
    {
      "code" : "PAINJ",
      "display" : "Injection, periarticular",
      "definition" : "Injection, periarticular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14679"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PeriarticularRoute"
        }
      ]
    },
    {
      "code" : "PARENTINJ",
      "display" : "Injection, parenteral",
      "definition" : "Injection, parenteral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16967"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ParenteralRoute"
        }
      ]
    },
    {
      "code" : "PDONTINJ",
      "display" : "Injection, periodontal",
      "definition" : "Injection, periodontal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16969"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PeriodontalRoute"
        }
      ]
    },
    {
      "code" : "PDPINJ",
      "display" : "Injection, peritoneal dialysis port",
      "definition" : "Injection, peritoneal dialysis port",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14681"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraperitonealRoute"
        }
      ]
    },
    {
      "code" : "PDURINJ",
      "display" : "Injection, peridural",
      "definition" : "Injection, peridural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16968"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PeriduralRoute"
        }
      ]
    },
    {
      "code" : "PNINJ",
      "display" : "Injection, perineural",
      "definition" : "Injection, perineural",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14680"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PerineuralRoute"
        }
      ]
    },
    {
      "code" : "PNSINJ",
      "display" : "Injection, paranasal sinuses",
      "definition" : "Injection, paranasal sinuses",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14678"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ParanasalSinusesRoute"
        }
      ]
    },
    {
      "code" : "RBINJ",
      "display" : "Injection, retrobulbar",
      "definition" : "Injection, retrobulbar",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14682"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RetrobulbarRoute"
        }
      ]
    },
    {
      "code" : "SCINJ",
      "display" : "Injection, subconjunctival",
      "definition" : "Injection, subconjunctival",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14683"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubconjunctivalRoute"
        }
      ]
    },
    {
      "code" : "SLESINJ",
      "display" : "Injection, sublesional",
      "definition" : "Injection, sublesional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14685"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SublesionalRoute"
        }
      ]
    },
    {
      "code" : "SOFTISINJ",
      "display" : "Injection, soft tissue",
      "definition" : "Injection, soft tissue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16970"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SoftTissueRoute"
        }
      ]
    },
    {
      "code" : "SQ",
      "display" : "Injection, subcutaneous",
      "definition" : "Injection, subcutaneous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14684"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubcutaneousRoute"
        }
      ]
    },
    {
      "code" : "SUBARACHINJ",
      "display" : "Injection, subarachnoid",
      "definition" : "Injection, subarachnoid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16971"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubarachnoidRoute"
        }
      ]
    },
    {
      "code" : "SUBMUCINJ",
      "display" : "Injection, submucosal",
      "definition" : "Injection, submucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16972"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubmucosalRoute"
        }
      ]
    },
    {
      "code" : "TRPLACINJ",
      "display" : "Injection, transplacental",
      "definition" : "Injection, transplacental",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16973"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TransplacentalRoute"
        }
      ]
    },
    {
      "code" : "TRTRACHINJ",
      "display" : "Injection, transtracheal",
      "definition" : "Injection, transtracheal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16974"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TranstrachealRoute"
        }
      ]
    },
    {
      "code" : "URETHINJ",
      "display" : "Injection, urethral",
      "definition" : "Injection, urethral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16976"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrethralRoute"
        }
      ]
    },
    {
      "code" : "URETINJ",
      "display" : "Injection, ureteral",
      "definition" : "Injection, ureteral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16975"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Injection"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UreteralRoute"
        }
      ]
    },
    {
      "code" : "IOSURGINS",
      "display" : "Insertion, intraocular, surgical",
      "definition" : "Insertion, intraocular, surgical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14689"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraocularRoute"
        }
      ]
    },
    {
      "code" : "IU",
      "display" : "Insertion, intrauterine",
      "definition" : "Insertion, intrauterine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14690"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrauterineRoute"
        }
      ]
    },
    {
      "code" : "LPINS",
      "display" : "Insertion, lacrimal puncta",
      "definition" : "Insertion, lacrimal puncta",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14691"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LacrimalPunctaRoute"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "Insertion, rectal",
      "definition" : "Insertion, rectal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14692"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        }
      ]
    },
    {
      "code" : "SQSURGINS",
      "display" : "Insertion, subcutaneous, surgical",
      "definition" : "Insertion, subcutaneous, surgical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14693"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubcutaneousRoute"
        }
      ]
    },
    {
      "code" : "URETHINS",
      "display" : "Insertion, urethral",
      "definition" : "Insertion, urethral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14694"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrethralRoute"
        }
      ]
    },
    {
      "code" : "VAGINSI",
      "display" : "Insertion, vaginal",
      "definition" : "Insertion, vaginal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14695"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Insertion"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_VaginalRoute"
        }
      ]
    },
    {
      "code" : "BLADINSTL",
      "display" : "Instillation, urinary catheter",
      "definition" : "Instillation, urinary catheter",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14719"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrinaryTractRoute"
        }
      ]
    },
    {
      "code" : "CAPDINSTL",
      "display" : "Instillation, continuous ambulatory peritoneal dialysis port",
      "definition" : "Instillation, continuous ambulatory peritoneal dialysis port",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14699"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraperitonealRoute"
        }
      ]
    },
    {
      "code" : "CTINSTL",
      "display" : "Instillation, chest tube",
      "definition" : "Instillation, chest tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14698"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrapleuralRoute"
        }
      ]
    },
    {
      "code" : "ETINSTL",
      "display" : "Instillation, endotracheal tube",
      "definition" : "Instillation, endotracheal tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14700"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "GJT",
      "display" : "Instillation, gastro-jejunostomy tube",
      "definition" : "Instillation, gastro-jejunostomy tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14703"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_JejunumRoute"
        }
      ]
    },
    {
      "code" : "IBRONCHINSTIL",
      "display" : "Instillation, intrabronchial",
      "definition" : "Instillation, intrabronchial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16977"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrabronchialRoute"
        }
      ]
    },
    {
      "code" : "IDUODINSTIL",
      "display" : "Instillation, intraduodenal",
      "definition" : "Instillation, intraduodenal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16978"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraduodenalRoute"
        }
      ]
    },
    {
      "code" : "IESOPHINSTIL",
      "display" : "Instillation, intraesophageal",
      "definition" : "Instillation, intraesophageal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16979"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraesophagealRoute"
        }
      ]
    },
    {
      "code" : "IGASTINSTIL",
      "display" : "Instillation, intragastric",
      "definition" : "Instillation, intragastric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16980"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntragastricRoute"
        }
      ]
    },
    {
      "code" : "IILEALINJ",
      "display" : "Instillation, intraileal",
      "definition" : "Instillation, intraileal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16981"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrailealRoute"
        }
      ]
    },
    {
      "code" : "IOINSTL",
      "display" : "Instillation, intraocular",
      "definition" : "Instillation, intraocular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14705"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraocularRoute"
        }
      ]
    },
    {
      "code" : "ISININSTIL",
      "display" : "Instillation, intrasinal",
      "definition" : "Instillation, intrasinal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16982"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrasinalRoute"
        }
      ]
    },
    {
      "code" : "ITRACHINSTIL",
      "display" : "Instillation, intratracheal",
      "definition" : "Instillation, intratracheal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16983"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratrachealRoute"
        }
      ]
    },
    {
      "code" : "IUINSTL",
      "display" : "Instillation, intrauterine",
      "definition" : "Instillation, intrauterine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14706"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrauterineRoute"
        }
      ]
    },
    {
      "code" : "JJTINSTL",
      "display" : "Instillation, jejunostomy tube",
      "definition" : "Instillation, jejunostomy tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14707"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_JejunumRoute"
        }
      ]
    },
    {
      "code" : "LARYNGINSTIL",
      "display" : "Instillation, laryngeal",
      "definition" : "Instillation, laryngeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16984"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LaryngealRoute"
        }
      ]
    },
    {
      "code" : "NASALINSTIL",
      "display" : "Instillation, nasal",
      "definition" : "Instillation, nasal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16985"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_NasalRoute"
        }
      ]
    },
    {
      "code" : "NASOGASINSTIL",
      "display" : "Instillation, nasogastric",
      "definition" : "Instillation, nasogastric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16986"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_NasalRoute"
        }
      ]
    },
    {
      "code" : "NTT",
      "display" : "Instillation, nasotracheal tube",
      "definition" : "Instillation, nasotracheal tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14709"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "OJJ",
      "display" : "Instillation, orojejunum tube",
      "definition" : "Instillation, orojejunum tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14711"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_JejunumRoute"
        }
      ]
    },
    {
      "code" : "OT",
      "display" : "Instillation, otic",
      "definition" : "Instillation, otic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14712"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OticRoute"
        }
      ]
    },
    {
      "code" : "PDPINSTL",
      "display" : "Instillation, peritoneal dialysis port",
      "definition" : "Instillation, peritoneal dialysis port",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14714"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraperitonealRoute"
        }
      ]
    },
    {
      "code" : "PNSINSTL",
      "display" : "Instillation, paranasal sinuses",
      "definition" : "Instillation, paranasal sinuses",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14713"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ParanasalSinusesRoute"
        }
      ]
    },
    {
      "code" : "RECINSTL",
      "display" : "Instillation, rectal",
      "definition" : "Instillation, rectal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14715"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        }
      ]
    },
    {
      "code" : "SININSTIL",
      "display" : "Instillation, sinus, unspecified",
      "definition" : "Instillation, sinus, unspecified",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16987"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SinusUnspecifiedRoute"
        }
      ]
    },
    {
      "code" : "SOFTISINSTIL",
      "display" : "Instillation, soft tissue",
      "definition" : "Instillation, soft tissue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16988"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SoftTissueRoute"
        }
      ]
    },
    {
      "code" : "TRACHINSTL",
      "display" : "Instillation, tracheostomy",
      "definition" : "Instillation, tracheostomy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14717"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TracheostomyRoute"
        }
      ]
    },
    {
      "code" : "TRTYMPINSTIL",
      "display" : "Instillation, transtympanic",
      "definition" : "Instillation, transtympanic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16989"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TranstympanicRoute"
        }
      ]
    },
    {
      "code" : "URETHINSTL",
      "display" : "instillation, urethral",
      "definition" : "Instillation, urethral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14718"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Instillation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrethralRoute"
        }
      ]
    },
    {
      "code" : "ICORNTA",
      "display" : "Topical application, intracorneal",
      "definition" : "Topical application, intracorneal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17008"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracornealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ICORONTA",
      "display" : "Topical application, intracoronal (dental)",
      "definition" : "Topical application, intracoronal (dental)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17009"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntracoronalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "IDOUDMAB",
      "display" : "Mucosal absorption, intraduodenal",
      "definition" : "Mucosal absorption, intraduodenal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16999"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraduodenalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MucosalAbsorptionRoute"
        }
      ]
    },
    {
      "code" : "IESOPHTA",
      "display" : "Topical application, intraesophageal",
      "definition" : "Topical application, intraesophageal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17010"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraesophagealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "IGASTIRR",
      "display" : "Irrigation, intragastric",
      "definition" : "Irrigation, intragastric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16993"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntragastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        }
      ]
    },
    {
      "code" : "IGASTLAV",
      "display" : "Lavage, intragastric",
      "definition" : "Lavage, intragastric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16996"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntragastricRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LavageRoute"
        }
      ]
    },
    {
      "code" : "IILEALTA",
      "display" : "Topical application, intraileal",
      "definition" : "Topical application, intraileal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17011"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntrailealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ILESIRR",
      "display" : "Irrigation, intralesional",
      "definition" : "Irrigation, intralesional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14723"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntralesionalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        }
      ]
    },
    {
      "code" : "ILTOP",
      "display" : "Topical application, intralesional",
      "definition" : "Topical application, intralesional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14745"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntralesionalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ILUMTA",
      "display" : "Topical application, intraluminal",
      "definition" : "Topical application, intraluminal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17012"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraluminalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "IOIRR",
      "display" : "Irrigation, intraocular",
      "definition" : "Irrigation, intraocular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14724"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraocularRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        }
      ]
    },
    {
      "code" : "IOTOP",
      "display" : "Topical application, intraocular",
      "definition" : "Topical application, intraocular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14746"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntraocularRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ITRACHMAB",
      "display" : "Mucosal absorption, intratracheal",
      "definition" : "Mucosal absorption, intratracheal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17000"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_IntratrachealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MucosalAbsorptionRoute"
        }
      ]
    },
    {
      "code" : "BLADIRR",
      "display" : "Irrigation, urinary bladder",
      "definition" : "Irrigation, urinary bladder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14725"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrinaryBladderRoute"
        }
      ]
    },
    {
      "code" : "RECIRR",
      "display" : "Irrigation, rectal",
      "definition" : "Irrigation, rectal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16994"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Irrigation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        }
      ]
    },
    {
      "code" : "LARYNGTA",
      "display" : "Topical application, laryngeal",
      "definition" : "Topical application, laryngeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17013"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LaryngealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "TRNSLING",
      "display" : "Translingual",
      "definition" : "Translingual",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14760"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LingualRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "SMUCMAB",
      "display" : "Mucosal absorption, submucosal",
      "definition" : "Mucosal absorption, submucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16998"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MucosalAbsorptionRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubmucosalRoute"
        }
      ]
    },
    {
      "code" : "MUC",
      "display" : "Topical application, mucous membrane",
      "definition" : "Topical application, mucous membrane",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14747"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MucousMembraneRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "NAIL",
      "display" : "Topical application, nail",
      "definition" : "Topical application, nail",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14748"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_NailRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "NASAL",
      "display" : "Topical application, nasal",
      "definition" : "Topical application, nasal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14749"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_NasalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ETNEB",
      "display" : "Nebulization, endotracheal tube",
      "definition" : "Nebulization, endotracheal tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14729"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Nebulization"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PulmonaryRoute"
        }
      ]
    },
    {
      "code" : "OPTHALTA",
      "display" : "Topical application, ophthalmic",
      "definition" : "Topical application, ophthalmic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17014"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OphthalmicRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ORALTA",
      "display" : "Topical application, oral",
      "definition" : "Topical application, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17015"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "ORRINSE",
      "display" : "Rinse, oral",
      "definition" : "Rinse, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14732"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Rinse"
        }
      ]
    },
    {
      "code" : "PO",
      "display" : "Swallow, oral",
      "definition" : "Swallow, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14735"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OralRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "GARGLE",
      "display" : "Gargle",
      "definition" : "Gargle",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14596"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OromucosalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "ORMUC",
      "display" : "Topical application, oromucosal",
      "definition" : "Topical application, oromucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14750"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OromucosalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "SUCK",
      "display" : "Suck, oromucosal",
      "definition" : "Suck, oromucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14734"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OromucosalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "SWISHSPIT",
      "display" : "Swish and spit out, oromucosal",
      "definition" : "Swish and spit out, oromucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14737"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OromucosalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Swish"
        }
      ]
    },
    {
      "code" : "SWISHSWAL",
      "display" : "Swish and swallow, oromucosal",
      "definition" : "Swish and swallow, oromucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14738"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OromucosalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Swish"
        }
      ]
    },
    {
      "code" : "OROPHARTA",
      "display" : "Topical application, oropharyngeal",
      "definition" : "Topical application, oropharyngeal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17016"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OropharyngealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "PERIANAL",
      "display" : "Topical application, perianal",
      "definition" : "Topical application, perianal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14751"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PerianalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "PERINEAL",
      "display" : "Topical application, perineal",
      "definition" : "Topical application, perineal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14752"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PerinealRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "PDONTTA",
      "display" : "Topical application, periodontal",
      "definition" : "Topical application, periodontal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17017"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PeriodontalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "RECTAL",
      "display" : "Topical application, rectal",
      "definition" : "Topical application, rectal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14753"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RectalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "_Chew",
      "display" : "Chew",
      "definition" : "Chew",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21142"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Diffusion",
      "display" : "Diffusion",
      "definition" : "Diffusion",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21144"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Dissolve",
      "display" : "Dissolve",
      "definition" : "Dissolve",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21145"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Douche",
      "display" : "Douche",
      "definition" : "Douche",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21146"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_ElectroOsmosisRoute",
      "display" : "ElectroOsmosisRoute",
      "definition" : "Electro-osmosis",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21147"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Enema",
      "display" : "Enema",
      "definition" : "Enema",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21149"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Flush",
      "display" : "Flush",
      "definition" : "Flush",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21154"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Implantation",
      "display" : "Implantation",
      "definition" : "Implantation",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21159"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Infusion",
      "display" : "Infusion",
      "definition" : "Infusion",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21161"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Inhalation",
      "display" : "Inhalation",
      "definition" : "Inhalation",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21162"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Injection",
      "display" : "Injection",
      "definition" : "Injection",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21163"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Insertion",
      "display" : "Insertion",
      "definition" : "Insertion",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21164"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Instillation",
      "display" : "Instillation",
      "definition" : "Instillation",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21165"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_IontophoresisRoute",
      "display" : "IontophoresisRoute",
      "definition" : "Iontophoresis",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21226"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Irrigation",
      "display" : "Irrigation",
      "definition" : "Irrigation",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21227"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_LavageRoute",
      "display" : "LavageRoute",
      "definition" : "Lavage",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21231"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_MucosalAbsorptionRoute",
      "display" : "MucosalAbsorptionRoute",
      "definition" : "Mucosal absorption",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21233"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Nebulization",
      "display" : "Nebulization",
      "definition" : "Nebulization",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21237"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Rinse",
      "display" : "Rinse",
      "definition" : "Rinse",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21255"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_SuppositoryRoute",
      "display" : "SuppositoryRoute",
      "definition" : "Suppository",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21268"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_Swish",
      "display" : "Swish",
      "definition" : "Swish",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21269"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_TopicalAbsorptionRoute",
      "display" : "TopicalAbsorptionRoute",
      "definition" : "Topical absorption",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21270"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_TopicalApplication",
      "display" : "TopicalApplication",
      "definition" : "Topical application",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21271"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "INSUF",
      "display" : "Insufflation",
      "definition" : "Insufflation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14720"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "TRNSDERM",
      "display" : "Transdermal",
      "definition" : "Transdermal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17356"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_InfiltrationRoute",
      "display" : "InfiltrationRoute",
      "definition" : "Infiltration",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21160"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteByMethod"
        }
      ]
    },
    {
      "code" : "_AmnioticFluidSacRoute",
      "display" : "AmnioticFluidSacRoute",
      "definition" : "Amniotic fluid sac",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21136"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_BiliaryRoute",
      "display" : "BiliaryRoute",
      "definition" : "Biliary tract",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21137"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_BodySurfaceRoute",
      "display" : "BodySurfaceRoute",
      "definition" : "Body surface",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21138"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_BuccalMucosaRoute",
      "display" : "BuccalMucosaRoute",
      "definition" : "Buccal mucosa",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21139"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_CecostomyRoute",
      "display" : "CecostomyRoute",
      "definition" : "Cecostomy",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21140"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_CervicalRoute",
      "display" : "CervicalRoute",
      "definition" : "Cervix of the uterus",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21141"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_EndocervicalRoute",
      "display" : "EndocervicalRoute",
      "definition" : "Endocervical",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21148"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_EnteralRoute",
      "display" : "EnteralRoute",
      "definition" : "Enteral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21150"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_EpiduralRoute",
      "display" : "EpiduralRoute",
      "definition" : "Epidural",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21151"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_ExtraAmnioticRoute",
      "display" : "ExtraAmnioticRoute",
      "definition" : "Extra-amniotic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21152"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_ExtracorporealCirculationRoute",
      "display" : "ExtracorporealCirculationRoute",
      "definition" : "Extracorporeal circulation",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21153"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_GastricRoute",
      "display" : "GastricRoute",
      "definition" : "Gastric",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21155"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_GenitourinaryRoute",
      "display" : "GenitourinaryRoute",
      "definition" : "Genitourinary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21156"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_GingivalRoute",
      "display" : "GingivalRoute",
      "definition" : "Gingival",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21157"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_HairRoute",
      "display" : "HairRoute",
      "definition" : "Hair",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21158"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_InterameningealRoute",
      "display" : "InterameningealRoute",
      "definition" : "Interameningeal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21166"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_InterstitialRoute",
      "display" : "InterstitialRoute",
      "definition" : "Interstitial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21167"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraabdominalRoute",
      "display" : "IntraabdominalRoute",
      "definition" : "Intra-abdominal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21168"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraarterialRoute",
      "display" : "IntraarterialRoute",
      "definition" : "Intra-arterial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21169"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraarticularRoute",
      "display" : "IntraarticularRoute",
      "definition" : "Intraarticular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21170"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrabronchialRoute",
      "display" : "IntrabronchialRoute",
      "definition" : "Intrabronchial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21171"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrabursalRoute",
      "display" : "IntrabursalRoute",
      "definition" : "Intrabursal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21172"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracardiacRoute",
      "display" : "IntracardiacRoute",
      "definition" : "Intracardiac",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21173"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracartilaginousRoute",
      "display" : "IntracartilaginousRoute",
      "definition" : "Intracartilaginous",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21174"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracaudalRoute",
      "display" : "IntracaudalRoute",
      "definition" : "Intracaudal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21175"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracavernosalRoute",
      "display" : "IntracavernosalRoute",
      "definition" : "Intracavernosal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21176"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracavitaryRoute",
      "display" : "IntracavitaryRoute",
      "definition" : "Intracavitary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21177"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracerebralRoute",
      "display" : "IntracerebralRoute",
      "definition" : "Intracerebral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21178"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracervicalRoute",
      "display" : "IntracervicalRoute",
      "definition" : "Intracervical",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21179"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracisternalRoute",
      "display" : "IntracisternalRoute",
      "definition" : "Intracisternal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21180"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracornealRoute",
      "display" : "IntracornealRoute",
      "definition" : "Intracorneal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21181"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracoronalRoute",
      "display" : "IntracoronalRoute",
      "definition" : "Intracoronal (dental)",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21182"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracoronaryRoute",
      "display" : "IntracoronaryRoute",
      "definition" : "Intracoronary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21183"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntracorpusCavernosumRoute",
      "display" : "IntracorpusCavernosumRoute",
      "definition" : "Intracorpus cavernosum",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21184"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntradermalRoute",
      "display" : "IntradermalRoute",
      "definition" : "Intradermal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21185"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntradiscalRoute",
      "display" : "IntradiscalRoute",
      "definition" : "Intradiscal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21186"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraductalRoute",
      "display" : "IntraductalRoute",
      "definition" : "Intraductal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21187"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraduodenalRoute",
      "display" : "IntraduodenalRoute",
      "definition" : "Intraduodenal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21188"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraduralRoute",
      "display" : "IntraduralRoute",
      "definition" : "Intradural",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21189"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraepidermalRoute",
      "display" : "IntraepidermalRoute",
      "definition" : "Intraepidermal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21190"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraepithelialRoute",
      "display" : "IntraepithelialRoute",
      "definition" : "Intraepithelial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21191"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraesophagealRoute",
      "display" : "IntraesophagealRoute",
      "definition" : "Intraesophageal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21192"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntragastricRoute",
      "display" : "IntragastricRoute",
      "definition" : "Intragastric",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21193"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrailealRoute",
      "display" : "IntrailealRoute",
      "definition" : "Intraileal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21194"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntralesionalRoute",
      "display" : "IntralesionalRoute",
      "definition" : "Intralesional",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21195"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraluminalRoute",
      "display" : "IntraluminalRoute",
      "definition" : "Intraluminal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21196"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntralymphaticRoute",
      "display" : "IntralymphaticRoute",
      "definition" : "Intralymphatic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21197"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntramedullaryRoute",
      "display" : "IntramedullaryRoute",
      "definition" : "Intramedullary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21198"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntramuscularRoute",
      "display" : "IntramuscularRoute",
      "definition" : "Intramuscular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21199"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraocularRoute",
      "display" : "IntraocularRoute",
      "definition" : "Intraocular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21200"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraosseousRoute",
      "display" : "IntraosseousRoute",
      "definition" : "Intraosseous",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21201"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraovarianRoute",
      "display" : "IntraovarianRoute",
      "definition" : "Intraovarian",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21202"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrapericardialRoute",
      "display" : "IntrapericardialRoute",
      "definition" : "Intrapericardial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21203"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraperitonealRoute",
      "display" : "IntraperitonealRoute",
      "definition" : "Intraperitoneal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21204"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrapleuralRoute",
      "display" : "IntrapleuralRoute",
      "definition" : "Intrapleural",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21205"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraprostaticRoute",
      "display" : "IntraprostaticRoute",
      "definition" : "Intraprostatic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21206"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrapulmonaryRoute",
      "display" : "IntrapulmonaryRoute",
      "definition" : "Intrapulmonary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21207"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrasinalRoute",
      "display" : "IntrasinalRoute",
      "definition" : "Intrasinal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21208"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraspinalRoute",
      "display" : "IntraspinalRoute",
      "definition" : "Intraspinal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21209"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrasternalRoute",
      "display" : "IntrasternalRoute",
      "definition" : "Intrasternal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21210"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrasynovialRoute",
      "display" : "IntrasynovialRoute",
      "definition" : "Intrasynovial",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21211"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratendinousRoute",
      "display" : "IntratendinousRoute",
      "definition" : "Intratendinous",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21212"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratesticularRoute",
      "display" : "IntratesticularRoute",
      "definition" : "Intratesticular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21213"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrathecalRoute",
      "display" : "IntrathecalRoute",
      "definition" : "Intrathecal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21214"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrathoracicRoute",
      "display" : "IntrathoracicRoute",
      "definition" : "Intrathoracic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21215"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratrachealRoute",
      "display" : "IntratrachealRoute",
      "definition" : "Intratracheal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21216"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratubularRoute",
      "display" : "IntratubularRoute",
      "definition" : "Intratubular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21217"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratumorRoute",
      "display" : "IntratumorRoute",
      "definition" : "Intratumor",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21218"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntratympanicRoute",
      "display" : "IntratympanicRoute",
      "definition" : "Intratympanic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21219"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntrauterineRoute",
      "display" : "IntrauterineRoute",
      "definition" : "Intrauterine",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21220"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntravascularRoute",
      "display" : "IntravascularRoute",
      "definition" : "Intravascular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21221"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntravenousRoute",
      "display" : "IntravenousRoute",
      "definition" : "Intravenous",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21222"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntraventricularRoute",
      "display" : "IntraventricularRoute",
      "definition" : "Intraventricular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21223"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntravesicleRoute",
      "display" : "IntravesicleRoute",
      "definition" : "Intravesicle",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21224"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_IntravitrealRoute",
      "display" : "IntravitrealRoute",
      "definition" : "Intravitreal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21225"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_JejunumRoute",
      "display" : "JejunumRoute",
      "definition" : "Jejunum",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21228"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_LacrimalPunctaRoute",
      "display" : "LacrimalPunctaRoute",
      "definition" : "Lacrimal puncta",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21229"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_LaryngealRoute",
      "display" : "LaryngealRoute",
      "definition" : "Laryngeal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21230"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_LingualRoute",
      "display" : "LingualRoute",
      "definition" : "Lingual",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21232"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_MucousMembraneRoute",
      "display" : "MucousMembraneRoute",
      "definition" : "Mucous membrane",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21234"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_NailRoute",
      "display" : "NailRoute",
      "definition" : "Nail",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21235"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_NasalRoute",
      "display" : "NasalRoute",
      "definition" : "Nasal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21236"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_OphthalmicRoute",
      "display" : "OphthalmicRoute",
      "definition" : "Ophthalmic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21238"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_OralRoute",
      "display" : "OralRoute",
      "definition" : "Oral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21239"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_OromucosalRoute",
      "display" : "OromucosalRoute",
      "definition" : "Oromucosal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21240"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_OropharyngealRoute",
      "display" : "OropharyngealRoute",
      "definition" : "Oropharyngeal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21241"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_OticRoute",
      "display" : "OticRoute",
      "definition" : "Otic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21242"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_ParanasalSinusesRoute",
      "display" : "ParanasalSinusesRoute",
      "definition" : "Paranasal sinuses",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21243"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_ParenteralRoute",
      "display" : "ParenteralRoute",
      "definition" : "Parenteral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21244"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PerianalRoute",
      "display" : "PerianalRoute",
      "definition" : "Perianal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21245"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PeriarticularRoute",
      "display" : "PeriarticularRoute",
      "definition" : "Periarticular",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21246"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PeriduralRoute",
      "display" : "PeriduralRoute",
      "definition" : "Peridural",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21247"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PerinealRoute",
      "display" : "PerinealRoute",
      "definition" : "Perineal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21248"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PerineuralRoute",
      "display" : "PerineuralRoute",
      "definition" : "Perineural",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21249"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PeriodontalRoute",
      "display" : "PeriodontalRoute",
      "definition" : "Periodontal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21250"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_PulmonaryRoute",
      "display" : "PulmonaryRoute",
      "definition" : "Pulmonary",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21251"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_RectalRoute",
      "display" : "RectalRoute",
      "definition" : "Rectal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21252"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_RespiratoryTractRoute",
      "display" : "RespiratoryTractRoute",
      "definition" : "Respiratory tract",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21253"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_RetrobulbarRoute",
      "display" : "RetrobulbarRoute",
      "definition" : "Retrobulbar",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21254"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_ScalpRoute",
      "display" : "ScalpRoute",
      "definition" : "Scalp",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21258"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SinusUnspecifiedRoute",
      "display" : "SinusUnspecifiedRoute",
      "definition" : "Sinus, unspecified",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21259"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SkinRoute",
      "display" : "SkinRoute",
      "definition" : "Skin",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21260"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SoftTissueRoute",
      "display" : "SoftTissueRoute",
      "definition" : "Soft tissue",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21261"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SubarachnoidRoute",
      "display" : "SubarachnoidRoute",
      "definition" : "Subarachnoid",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21262"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SubconjunctivalRoute",
      "display" : "SubconjunctivalRoute",
      "definition" : "Subconjunctival",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21263"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SubcutaneousRoute",
      "display" : "SubcutaneousRoute",
      "definition" : "Subcutaneous",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21264"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SublesionalRoute",
      "display" : "SublesionalRoute",
      "definition" : "Sublesional",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21265"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SublingualRoute",
      "display" : "SublingualRoute",
      "definition" : "Sublingual",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21266"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_SubmucosalRoute",
      "display" : "SubmucosalRoute",
      "definition" : "Submucosal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21267"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_TracheostomyRoute",
      "display" : "TracheostomyRoute",
      "definition" : "Tracheostomy",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21272"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_TransmucosalRoute",
      "display" : "TransmucosalRoute",
      "definition" : "Transmucosal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21273"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_TransplacentalRoute",
      "display" : "TransplacentalRoute",
      "definition" : "Transplacental",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21274"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_TranstrachealRoute",
      "display" : "TranstrachealRoute",
      "definition" : "Transtracheal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21275"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_TranstympanicRoute",
      "display" : "TranstympanicRoute",
      "definition" : "Transtympanic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21276"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_UreteralRoute",
      "display" : "UreteralRoute",
      "definition" : "Ureteral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21277"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_UrethralRoute",
      "display" : "UrethralRoute",
      "definition" : "Urethral",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21278"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_UrinaryBladderRoute",
      "display" : "UrinaryBladderRoute",
      "definition" : "Urinary bladder",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21279"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_UrinaryTractRoute",
      "display" : "UrinaryTractRoute",
      "definition" : "Urinary tract",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21280"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_VaginalRoute",
      "display" : "VaginalRoute",
      "definition" : "Vaginal",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21281"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_VitreousHumourRoute",
      "display" : "VitreousHumourRoute",
      "definition" : "Vitreous humour",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21282"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "_DentalRoute",
      "display" : "DentalRoute",
      "definition" : "Dental",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21143"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RouteBySite"
        }
      ]
    },
    {
      "code" : "SCALP",
      "display" : "Topical application, scalp",
      "definition" : "Topical application, scalp",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14754"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ScalpRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "OCDRESTA",
      "display" : "Occlusive dressing technique",
      "definition" : "Occlusive dressing technique",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17001"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SkinRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "SKIN",
      "display" : "Topical application, skin",
      "definition" : "Topical application, skin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14755"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SkinRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "SUBCONJTA",
      "display" : "Subconjunctival",
      "definition" : "Subconjunctival",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17002"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubconjunctivalRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        }
      ]
    },
    {
      "code" : "URETHSUP",
      "display" : "Suppository, urethral",
      "definition" : "Suppository, urethral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17004"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SuppositoryRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_UrethralRoute"
        }
      ]
    },
    {
      "code" : "TTYMPTABSORP",
      "display" : "Topical absorption, transtympanic",
      "definition" : "Topical absorption, transtympanic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17007"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalAbsorptionRoute"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TranstympanicRoute"
        }
      ]
    },
    {
      "code" : "TMUCTA",
      "display" : "Topical application, transmucosal",
      "definition" : "Topical application, transmucosal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17018"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TransmucosalRoute"
        }
      ]
    },
    {
      "code" : "VAGINS",
      "display" : "Topical application, vaginal",
      "definition" : "Insertion, vaginal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14758"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TopicalApplication"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_VaginalRoute"
        }
      ]
    },
    {
      "code" : "BLADIRRC",
      "display" : "Irrigation, urinary bladder, continuous",
      "definition" : "Irrigation, urinary bladder, continuous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14726"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BLADIRR"
        }
      ]
    },
    {
      "code" : "BLADIRRT",
      "display" : "Irrigation, urinary bladder, tidal",
      "definition" : "Irrigation, urinary bladder, tidal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14727"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BLADIRR"
        }
      ]
    },
    {
      "code" : "IAINJP",
      "display" : "Injection, intraarterial, push",
      "definition" : "Injection, intraarterial, push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14640"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IAINJ"
        }
      ]
    },
    {
      "code" : "IAINJSP",
      "display" : "Injection, intraarterial, slow push",
      "definition" : "Injection, intraarterial, slow push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14641"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IAINJ"
        }
      ]
    },
    {
      "code" : "ICARDINJRP",
      "display" : "Injection, intracardiac, rapid push",
      "definition" : "Injection, intracardiac, rapid push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14646"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ICARDINJ"
        }
      ]
    },
    {
      "code" : "ICARDINJSP",
      "display" : "Injection, intracardiac, slow push",
      "definition" : "Injection, intracardiac, slow push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14647"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ICARDINJ"
        }
      ]
    },
    {
      "code" : "ICARINJP",
      "display" : "Injection, intracardiac, push",
      "definition" : "Injection, intracardiac, push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14645"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ICARDINJ"
        }
      ]
    },
    {
      "code" : "ICORONINJP",
      "display" : "Injection, intracoronary, push",
      "definition" : "Injection, intracoronary, push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14651"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ICORONINJ"
        }
      ]
    },
    {
      "code" : "IMD",
      "display" : "Injection, intramuscular, deep",
      "definition" : "Injection, intramuscular, deep",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14658"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IM"
        }
      ]
    },
    {
      "code" : "IMZ",
      "display" : "Injection, intramuscular, z track",
      "definition" : "Injection, intramuscular, z track",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14659"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IM"
        }
      ]
    },
    {
      "code" : "ORIFINHL",
      "display" : "Inhalation, oral intermittent flow",
      "definition" : "Inhalation, oral intermittent flow",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14623"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IPINHL"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORINHL"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RESPINHL"
        }
      ]
    },
    {
      "code" : "REBREATH",
      "display" : "Inhalation, oral rebreather mask",
      "definition" : "Inhalation, oral rebreather mask",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14624"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IPINHL"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORINHL"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RESPINHL"
        }
      ]
    },
    {
      "code" : "IVC",
      "display" : "Infusion, intravenous catheter",
      "definition" : "Infusion, intravenous catheter",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14610"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IV"
        }
      ]
    },
    {
      "code" : "IVCC",
      "display" : "Infusion, intravenous catheter, continuous",
      "definition" : "Infusion, intravenous catheter, continuous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14611"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IV"
        }
      ]
    },
    {
      "code" : "IVCI",
      "display" : "Infusion, intravenous catheter, intermittent",
      "definition" : "Infusion, intravenous catheter, intermittent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14612"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IV"
        }
      ]
    },
    {
      "code" : "PCA",
      "display" : "Infusion, intravenous catheter, pca pump",
      "definition" : "Infusion, intravenous catheter, pca pump",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14613"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IV"
        }
      ]
    },
    {
      "code" : "IVINJBOL",
      "display" : "Injection, intravenous, bolus",
      "definition" : "Injection, intravenous, bolus",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14671"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IVINJ"
        }
      ]
    },
    {
      "code" : "IVPUSH",
      "display" : "Injection, intravenous, push",
      "definition" : "Injection, intravenous, push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14672"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IVINJ"
        }
      ]
    },
    {
      "code" : "IVRPUSH",
      "display" : "Injection, intravenous, rapid push",
      "definition" : "Injection, intravenous, rapid push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14673"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IVINJ"
        }
      ]
    },
    {
      "code" : "IVSPUSH",
      "display" : "Injection, intravenous, slow push",
      "definition" : "Injection, intravenous, slow push",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14674"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IVINJ"
        }
      ]
    },
    {
      "code" : "NASINHLC",
      "display" : "Inhalation, nasal cannula",
      "definition" : "Inhalation, nasal, prongs",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, nasal, prongs"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "NP"
        },
        {
          "code" : "internalId",
          "valueCode" : "14618"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NASINHL"
        }
      ]
    },
    {
      "code" : "NP",
      "display" : "Inhalation, nasal cannula",
      "definition" : "Inhalation, nasal, prongs",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Inhalation, nasal, prongs"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "NASINHLC"
        },
        {
          "code" : "internalId",
          "valueCode" : "14618"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NASINHL"
        }
      ]
    },
    {
      "code" : "NASNEB",
      "display" : "Inhalation, nebulization, nasal",
      "definition" : "Inhalation, nebulization, nasal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14620"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NEB"
        }
      ]
    },
    {
      "code" : "ORNEB",
      "display" : "Inhalation, nebulization, oral",
      "definition" : "Inhalation, nebulization, oral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14621"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NEB"
        }
      ]
    },
    {
      "code" : "RECTINSTL",
      "display" : "Instillation, rectal tube",
      "definition" : "Instillation, rectal tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14716"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RECINSTL"
        }
      ]
    }
  ]
}

```
