# QueryParameterValue - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QueryParameterValue**

## CodeSystem: QueryParameterValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-QueryParameterValue | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QueryParameterValue |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1096 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The domain of coded values used as parameters within QueryByParameter queries. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [IssueFilterCode](ValueSet-v3-IssueFilterCode.md)
* [PrescriptionDispenseFilterCode](ValueSet-v3-PrescriptionDispenseFilterCode.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-QueryParameterValue",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-QueryParameterValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1096"
    }
  ],
  "version" : "3.0.0",
  "name" : "QueryParameterValue",
  "title" : "QueryParameterValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The domain of coded values used as parameters within QueryByParameter queries.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_DispenseQueryFilterCode",
      "display" : "dispense query filter code",
      "definition" : "**Description:**Filter codes used to manage volume of dispenses returned by a parameter-based queries.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23299"
        }
      ],
      "concept" : [
        {
          "code" : "ALLDISP",
          "display" : "all dispenses",
          "definition" : "**Description:**Returns all dispenses to date for a prescription.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23300"
            }
          ]
        },
        {
          "code" : "LASTDISP",
          "display" : "last dispense",
          "definition" : "**Description:**Returns the most recent dispense for a prescription.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23301"
            }
          ]
        },
        {
          "code" : "NODISP",
          "display" : "no dispense",
          "definition" : "**Description:**Returns no dispense for a prescription.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23302"
            }
          ]
        }
      ]
    },
    {
      "code" : "_OrderFilterCode",
      "display" : "_OrderFilterCode",
      "definition" : "Filter codes used to manage types of orders being returned by a parameter-based query.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23616"
        }
      ],
      "concept" : [
        {
          "code" : "AO",
          "display" : "all orders",
          "definition" : "Return all orders.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23617"
            }
          ]
        },
        {
          "code" : "ONR",
          "display" : "orders without results",
          "definition" : "Return only those orders that do not have results.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23619"
            }
          ]
        },
        {
          "code" : "OWR",
          "display" : "orders with results",
          "definition" : "Return only those orders that have results.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23618"
            }
          ]
        }
      ]
    },
    {
      "code" : "_PrescriptionDispenseFilterCode",
      "display" : "Prescription Dispense Filter Code",
      "definition" : "A \"helper\" vocabulary used to construct complex query filters based on how and whether a prescription has been dispensed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21537"
        }
      ],
      "concept" : [
        {
          "code" : "C",
          "display" : "Completely dispensed",
          "definition" : "Filter to only include SubstanceAdministration orders which have no remaining quantity authorized to be dispensed.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21540"
            }
          ]
        },
        {
          "code" : "N",
          "display" : "Never Dispensed",
          "definition" : "Filter to only include SubstanceAdministration orders which have no fulfilling supply events performed.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21538"
            }
          ]
        },
        {
          "code" : "R",
          "display" : "Dispensed with remaining fills",
          "definition" : "Filter to only include SubstanceAdministration orders which have had at least one fulfilling supply event, but which still have outstanding quantity remaining to be authorized.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21539"
            }
          ]
        }
      ]
    },
    {
      "code" : "_QueryParameterValue",
      "display" : "QueryParameterValue",
      "definition" : "**Description:**Indicates how result sets should be filtered based on whether they have associated issues.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21986"
        }
      ],
      "concept" : [
        {
          "code" : "ISSFA",
          "display" : "all",
          "definition" : "**Description:**Result set should not be filtered based on the presence of issues.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21987"
            }
          ]
        },
        {
          "code" : "ISSFI",
          "display" : "with issues",
          "definition" : "**Description:**Result set should be filtered to only include records with associated issues.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21988"
            }
          ]
        },
        {
          "code" : "ISSFU",
          "display" : "with unmanaged issues",
          "definition" : "**Description:**Result set should be filtered to only include records with associated unmanaged issues.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21989"
            }
          ]
        }
      ]
    }
  ]
}

```
