# itemStatus - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **itemStatus**

## CodeSystem: itemStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0776 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ItemStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.402 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the status (useful for reporting and item usage purposes) that applies to an item. Used in HL7 Version 2.x messaging in the ITM segment. 

 
Underlying Master Code System for V2 table 0776 (Item Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSItemStatus](ValueSet-v2-0776.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0776",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "mnm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0776",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.402"
    }
  ],
  "version" : "2.0.0",
  "name" : "ItemStatus",
  "title" : "itemStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status (useful for reporting and item usage purposes) that applies to an item. Used in HL7 Version 2.x messaging in the ITM segment.",
  "purpose" : "Underlying Master Code System for V2 table 0776 (Item Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0776",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6472",
      "code" : "A",
      "display" : "Active",
      "definition" : "Active",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is available to be purchased or issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is available to be purchased or issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6473",
      "code" : "P",
      "display" : "Pending Inactive",
      "definition" : "Pending Inactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is not available to be purchased, but is available to be issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is not available to be purchased, but is available to be issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6474",
      "code" : "I",
      "display" : "Inactive",
      "definition" : "Inactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is not available to be purchased or issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is not available to be purchased or issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
