# invoiceType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **invoiceType**

## CodeSystem: invoiceType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0555 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InvoiceType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.359 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the type of invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0555 (Invoice Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSInvoiceType](ValueSet-v2-0555.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0555",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0555",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.359"
    }
  ],
  "version" : "2.0.0",
  "name" : "InvoiceType",
  "title" : "invoiceType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the type of invoice.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0555 (Invoice Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0555",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6166",
      "code" : "FS",
      "display" : "Fee for Service",
      "definition" : "Fee for Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6167",
      "code" : "SS",
      "display" : "By Session",
      "definition" : "By Session",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6168",
      "code" : "GP",
      "display" : "Group",
      "definition" : "Group",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6169",
      "code" : "BK",
      "display" : "Block",
      "definition" : "Block",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6170",
      "code" : "SL",
      "display" : "Salary",
      "definition" : "Salary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6171",
      "code" : "IN",
      "display" : "Information Only",
      "definition" : "Information Only",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Payee information not required for this Invoice Type"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Payee information not required for this Invoice Type"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6172",
      "code" : "NP",
      "display" : "Non Patient",
      "definition" : "Non Patient",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Invoice without a patient.  E.g. bulk invoicing for Pharmacy for a care facility."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Invoice without a patient.  E.g. bulk invoicing for Pharmacy for a care facility."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6173",
      "code" : "FN",
      "display" : "Final",
      "definition" : "Final",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Final Invoice"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Final Invoice"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6174",
      "code" : "PA",
      "display" : "Partial",
      "definition" : "Partial",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Partial Invoice"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Partial Invoice"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6175",
      "code" : "SU",
      "display" : "Supplemental",
      "definition" : "Supplemental",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Supplemental Invoice"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Supplemental Invoice"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
