# bloodProductProcessingRequirements - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **bloodProductProcessingRequirements**

## CodeSystem: bloodProductProcessingRequirements 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0508 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BloodProductProcessingRequirements |
| *Other Identifiers:*OID:2.16.840.1.113883.18.332 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID. The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient. Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0508 (Blood Product Processing Requirements) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSBloodProductProcessingRequirements](ValueSet-v2-0508.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0508",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0508",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.332"
    }
  ],
  "version" : "2.0.0",
  "name" : "BloodProductProcessingRequirements",
  "title" : "bloodProductProcessingRequirements",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient.  Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0508 (Blood Product Processing Requirements)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0508",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5532",
      "code" : "LR",
      "display" : "Leukoreduced",
      "definition" : "Leukoreduced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5533",
      "code" : "IR",
      "display" : "Irradiated",
      "definition" : "Irradiated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5534",
      "code" : "CS",
      "display" : "CMV Safe",
      "definition" : "CMV Safe",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5535",
      "code" : "FR",
      "display" : "Fresh unit",
      "definition" : "Fresh unit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5536",
      "code" : "AU",
      "display" : "Autologous Unit",
      "definition" : "Autologous Unit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5537",
      "code" : "DI",
      "display" : "Directed Unit",
      "definition" : "Directed Unit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5538",
      "code" : "HL",
      "display" : "HLA Matched",
      "definition" : "HLA Matched",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5539",
      "code" : "CM",
      "display" : "CMV Negative",
      "definition" : "CMV Negative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5540",
      "code" : "HB",
      "display" : "Hemoglobin S Negative",
      "definition" : "Hemoglobin S Negative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5541",
      "code" : "WA",
      "display" : "Washed",
      "definition" : "Washed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5542",
      "code" : "IG",
      "display" : "IgA Deficient",
      "definition" : "IgA Deficient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
