# cyclicEntryExitIndicator - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **cyclicEntryExitIndicator**

## CodeSystem: cyclicEntryExitIndicator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0505 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CyclicEntryExitIndicator |
| *Other Identifiers:*OID:2.16.840.1.113883.18.329 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0505 (Cyclic Entry/Exit Indicator) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSCyclicEntryExitIndicator](ValueSet-v2-0505.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0505",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0505",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.329"
    }
  ],
  "version" : "2.0.0",
  "name" : "CyclicEntryExitIndicator",
  "title" : "cyclicEntryExitIndicator",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0505 (Cyclic Entry/Exit Indicator)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0505",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5518",
      "code" : "F",
      "display" : "First service",
      "definition" : "The first service request in a cyclic group",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5519",
      "code" : "L",
      "display" : "Last service",
      "definition" : "The last service request in a cyclic group",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5520",
      "code" : "*",
      "display" : "The first service request in a cyclic group",
      "definition" : "The first service request in a cyclic group",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "Retired March 2016. Use code F instead"
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    },
    {
      "id" : "5521",
      "code" : "#",
      "display" : "The last service request in a cyclic group.",
      "definition" : "The last service request in a cyclic group.",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "Retired March 2016. Use code L instead"
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    }
  ]
}

```
