# specimenRejectReason - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **specimenRejectReason**

## CodeSystem: specimenRejectReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0490 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecimenRejectReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.314 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis. Used in HL7 Version 2.x messaging in the SPM segment. 

 
Underlying Master Code System for V2 table 0490 (Specimen Reject Reason) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSpecimenRejectReason](ValueSet-v2-0490.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0490",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0490",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.314"
    }
  ],
  "version" : "2.0.0",
  "name" : "SpecimenRejectReason",
  "title" : "specimenRejectReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis.  Used in HL7 Version 2.x messaging in the SPM segment.",
  "purpose" : "Underlying Master Code System for V2 table 0490 (Specimen Reject Reason)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0490",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5303",
      "code" : "EX",
      "display" : "Expired",
      "definition" : "Expired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5304",
      "code" : "QS",
      "display" : "Quantity not sufficient",
      "definition" : "Quantity not sufficient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5305",
      "code" : "RB",
      "display" : "Broken container",
      "definition" : "Broken container",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5306",
      "code" : "RC",
      "display" : "Clotting",
      "definition" : "Clotting",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5307",
      "code" : "RD",
      "display" : "Missing collection date",
      "definition" : "Missing collection date",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5308",
      "code" : "RA",
      "display" : "Missing patient ID number",
      "definition" : "Missing patient ID number",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5309",
      "code" : "RE",
      "display" : "Missing patient name",
      "definition" : "Missing patient name",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5310",
      "code" : "RH",
      "display" : "Hemolysis",
      "definition" : "Hemolysis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5311",
      "code" : "RI",
      "display" : "Identification problem",
      "definition" : "Identification problem",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5312",
      "code" : "RM",
      "display" : "Labeling",
      "definition" : "Labeling",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5313",
      "code" : "RN",
      "display" : "Contamination",
      "definition" : "Contamination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5314",
      "code" : "RP",
      "display" : "Missing phlebotomist ID",
      "definition" : "Missing phlebotomist ID",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5315",
      "code" : "RR",
      "display" : "Improper storage",
      "definition" : "Improper storage",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5316",
      "code" : "RS",
      "display" : "Name misspelling",
      "definition" : "Name misspelling",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
