# reimbursementType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **reimbursementType**

## CodeSystem: reimbursementType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0470 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ReimbursementType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.299 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the fee schedule reimbursement type applied to the line item. Used in HL7 Version 2.x messaging in the GP2 segment. 

 
Underlying Master Code System for V2 table 0470 (Reimbursement Type Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSReimbursementTypeCode](ValueSet-v2-0470.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0470",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0470",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.299"
    }
  ],
  "version" : "2.0.0",
  "name" : "ReimbursementType",
  "title" : "reimbursementType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the fee schedule reimbursement type applied to the line item.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0470 (Reimbursement Type Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0470",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4859",
      "code" : "OPPS",
      "display" : "Outpatient Prospective Payment System",
      "definition" : "Outpatient Prospective Payment System",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4860",
      "code" : "Pckg",
      "display" : "Packaged APC",
      "definition" : "Packaged APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4861",
      "code" : "Lab",
      "display" : "Clinical Laboratory APC",
      "definition" : "Clinical Laboratory APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4862",
      "code" : "Thrpy",
      "display" : "Therapy APC",
      "definition" : "Therapy APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4863",
      "code" : "DME",
      "display" : "Durable Medical Equipment",
      "definition" : "Durable Medical Equipment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4864",
      "code" : "EPO",
      "display" : "Epotein",
      "definition" : "Epotein",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4865",
      "code" : "Mamm",
      "display" : "Screening Mammography APC",
      "definition" : "Screening Mammography APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4866",
      "code" : "PartH",
      "display" : "Partial Hospitalization APC",
      "definition" : "Partial Hospitalization APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4867",
      "code" : "Crnl",
      "display" : "Corneal Tissue APC",
      "definition" : "Corneal Tissue APC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4868",
      "code" : "NoPay",
      "display" : "This APC is not paid",
      "definition" : "This APC is not paid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
