# procedureDrgType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **procedureDrgType**

## CodeSystem: procedureDrgType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0416 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcedureDrgType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.258 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG. Used in HL7 Version 2 messaging in the PR1 segment. 

 
Underlying Master Code System for V2 table 0416 (Procedure DRG Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcedureDrgType](ValueSet-v2-0416.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0416",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0416",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.258"
    }
  ],
  "version" : "2.0.0",
  "name" : "ProcedureDrgType",
  "title" : "procedureDrgType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG.  Used in HL7 Version 2 messaging in the PR1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0416 (Procedure DRG Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0416",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4550",
      "code" : "1",
      "display" : "1st non-Operative",
      "definition" : "1st non-Operative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4551",
      "code" : "2",
      "display" : "2nd non-Operative",
      "definition" : "2nd non-Operative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4552",
      "code" : "3",
      "display" : "Major Operative",
      "definition" : "Major Operative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4553",
      "code" : "4",
      "display" : "2nd Operative",
      "definition" : "2nd Operative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4554",
      "code" : "5",
      "display" : "3rd Operative",
      "definition" : "3rd Operative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
