# commandResponse - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **commandResponse**

## CodeSystem: commandResponse 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0387 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CommandResponse |
| *Other Identifiers:*OID:2.16.840.1.113883.18.238 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts identifying the response of the previously issued command. Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments. 

 
Underlying Master Code System for V2 table 0387 (Command Response) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSCommandResponse](ValueSet-v2-0387.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0387",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0387",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.238"
    }
  ],
  "version" : "2.0.0",
  "name" : "CommandResponse",
  "title" : "commandResponse",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts identifying the response of the previously issued command.  Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments.",
  "purpose" : "Underlying Master Code System for V2 table 0387 (Command Response)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0387",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "3853",
      "code" : "OK",
      "display" : "Command completed successfully",
      "definition" : "Command completed successfully",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3854",
      "code" : "TI",
      "display" : "Command cannot be completed within requested completion time",
      "definition" : "Command cannot be completed within requested completion time",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3855",
      "code" : "ER",
      "display" : "Command cannot be completed because of error condition",
      "definition" : "Command cannot be completed because of error condition",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "See response parameters."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "See response parameters."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3856",
      "code" : "ST",
      "display" : "Command cannot be completed because of the status of the requested equipment",
      "definition" : "Command cannot be completed because of the status of the requested equipment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3857",
      "code" : "UN",
      "display" : "Command cannot be completed for unknown reasons",
      "definition" : "Command cannot be completed for unknown reasons",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
