# specimenRole - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **specimenRole**

## CodeSystem: specimenRole 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0369 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecimenRole |
| *Other Identifiers:*OID:2.16.840.1.113883.18.227 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments. 

 
Underlying Master Code System for V2 table 0369 (Specimen Role) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSpecimenRole](ValueSet-v2-0369.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0369",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0369",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.227"
    }
  ],
  "version" : "2.0.0",
  "name" : "SpecimenRole",
  "title" : "specimenRole",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify the role of a sample.  Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments.",
  "purpose" : "Underlying Master Code System for V2 table 0369 (Specimen Role)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0369",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "3714",
      "code" : "B",
      "display" : "Blind Sample",
      "definition" : "Used to test the validity of the measurement process, where the composition of the sample is unknown except to the person submitting it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3715",
      "code" : "C",
      "display" : "Calibrator",
      "definition" : "Used for initial setting of calibration of the instrument.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3716",
      "code" : "E",
      "display" : "Electronic QC",
      "definition" : "Used with manufactured reference providing signals that simulate QC results",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3717",
      "code" : "F",
      "display" : "Filler Organization Proficiency",
      "definition" : "Specimen used for testing proficiency of the organization performing the testing (Filler).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3718",
      "code" : "G",
      "display" : "Group",
      "definition" : "Used when solid specimens consist of multiple individual elements that are not individually identified but can be separated again into the original specimens.  The identifiers of the original specimens may be tracked.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3719",
      "code" : "H",
      "display" : "Historical Specimen",
      "definition" : "This identifies a parent specimen to the specimen that is submitted for testing",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The order of specimen processing can be derived from the SPM-3 value in all SPM segments in the message.  More than one historical SPM can be submitted, each SPM describes one step in the derivation process of the specimen submitted for testing."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "3720",
      "code" : "L",
      "display" : "Pool",
      "definition" : "Used when aliquots of liquid individual specimens are combined to form a single specimen representing all of the components that are not individually identified.  The identifiers of the original specimens may be tracked.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3721",
      "code" : "O",
      "display" : "Operator Proficiency",
      "definition" : "Specimen used for testing Operator Proficiency.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3722",
      "code" : "P",
      "display" : "Patient",
      "definition" : "Used for any patient sample.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "If the component is not valued (blank) this represents the default meaning."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3723",
      "code" : "Q",
      "display" : "Control specimen",
      "definition" : "Used when specimen is the control specimen (either positive or negative).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3724",
      "code" : "R",
      "display" : "Replicate (of patient sample as a control)",
      "definition" : "Used when a patient sample is re-run as a control for a repeat test.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3725",
      "code" : "V",
      "display" : "Verifying Calibrator",
      "definition" : "Used for periodic calibration checks.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
