# commentType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **commentType**

## CodeSystem: commentType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0364 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CommentType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.222 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts that identify the type of comment text being sent in the specific comment record. Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0364 (Comment Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSCommentType](ValueSet-v2-0364.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0364",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0364",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.222"
    }
  ],
  "version" : "2.0.0",
  "name" : "CommentType",
  "title" : "commentType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the type of comment text being sent in the specific comment record.  Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0364 (Comment Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0364",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "3655",
      "code" : "PI",
      "display" : "Patient Instructions",
      "definition" : "Patient Instructions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3656",
      "code" : "AI",
      "display" : "Ancillary Instructions",
      "definition" : "Ancillary Instructions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3657",
      "code" : "GI",
      "display" : "General Instructions",
      "definition" : "General Instructions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3658",
      "code" : "1R",
      "display" : "Primary Reason",
      "definition" : "Primary Reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3659",
      "code" : "2R",
      "display" : "Secondary Reason",
      "definition" : "Secondary Reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3660",
      "code" : "GR",
      "display" : "General Reason",
      "definition" : "General Reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3661",
      "code" : "RE",
      "display" : "Remark",
      "definition" : "Remark",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3662",
      "code" : "DR",
      "display" : "Duplicate/Interaction Reason",
      "definition" : "Duplicate/Interaction Reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
