# degreeLicenseCertificate - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **degreeLicenseCertificate**

## CodeSystem: degreeLicenseCertificate 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0360 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DegreeLicenseCertificate |
| *Other Identifiers:*OID:2.16.840.1.113883.18.220 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. 

 
Underlying Master Code System for V2 table 0360 (Degree/License/Certificate) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDegreeLicenseCertificate](ValueSet-v2-0360.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0360",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0360",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.220"
    }
  ],
  "version" : "2.0.0",
  "name" : "DegreeLicenseCertificate",
  "title" : "degreeLicenseCertificate",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.  Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7.",
  "purpose" : "Underlying Master Code System for V2 table 0360 (Degree/License/Certificate)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0360",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "3594",
      "code" : "PN",
      "display" : "Advanced Practice Nurse",
      "definition" : "Advanced Practice Nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3595",
      "code" : "AAS",
      "display" : "Associate of Applied Science",
      "definition" : "Associate of Applied Science",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3596",
      "code" : "AA",
      "display" : "Associate of Arts",
      "definition" : "Associate of Arts",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3597",
      "code" : "ABA",
      "display" : "Associate of Business Administration",
      "definition" : "Associate of Business Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3598",
      "code" : "AE",
      "display" : "Associate of Engineering",
      "definition" : "Associate of Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3599",
      "code" : "AS",
      "display" : "Associate of Science",
      "definition" : "Associate of Science",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3600",
      "code" : "BA",
      "display" : "Bachelor of Arts",
      "definition" : "Bachelor of Arts",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3601",
      "code" : "BBA",
      "display" : "Bachelor of Business Administration",
      "definition" : "Bachelor of Business Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3602",
      "code" : "BE",
      "display" : "Bachelor or Engineering",
      "definition" : "Bachelor or Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3603",
      "code" : "BFA",
      "display" : "Bachelor of Fine Arts",
      "definition" : "Bachelor of Fine Arts",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3604",
      "code" : "BN",
      "display" : "Bachelor of Nursing",
      "definition" : "Bachelor of Nursing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3605",
      "code" : "BS",
      "display" : "Bachelor of Science",
      "definition" : "Bachelor of Science",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3606",
      "code" : "BSL",
      "display" : "Bachelor of Science - Law",
      "definition" : "Bachelor of Science - Law",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3607",
      "code" : "BSN",
      "display" : "Bachelor on Science - Nursing",
      "definition" : "Bachelor on Science - Nursing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3608",
      "code" : "BT",
      "display" : "Bachelor of Theology",
      "definition" : "Bachelor of Theology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3609",
      "code" : "CER",
      "display" : "Certificate",
      "definition" : "Certificate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3610",
      "code" : "CANP",
      "display" : "Certified Adult Nurse Practitioner",
      "definition" : "Certified Adult Nurse Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3611",
      "code" : "CMA",
      "display" : "Certified Medical Assistant",
      "definition" : "Certified Medical Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3612",
      "code" : "CNP",
      "display" : "Certified Nurse Practitioner",
      "definition" : "Certified Nurse Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3613",
      "code" : "CNM",
      "display" : "Certified Nurse Midwife",
      "definition" : "Certified Nurse Midwife",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3614",
      "code" : "CRN",
      "display" : "Certified Registered Nurse",
      "definition" : "Certified Registered Nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3615",
      "code" : "CNS",
      "display" : "Certified Nurse Specialist",
      "definition" : "Certified Nurse Specialist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3616",
      "code" : "CPNP",
      "display" : "Certified Pediatric Nurse Practitioner",
      "definition" : "Certified Pediatric Nurse Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3617",
      "code" : "CTR",
      "display" : "Certified Tumor Registrar",
      "definition" : "Certified Tumor Registrar",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3618",
      "code" : "DIP",
      "display" : "Diploma",
      "definition" : "Diploma",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3619",
      "code" : "DBA",
      "display" : "Doctor of Business Administration",
      "definition" : "Doctor of Business Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3620",
      "code" : "DED",
      "display" : "Doctor of Education",
      "definition" : "Doctor of Education",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3621",
      "code" : "PharmD",
      "display" : "Doctor of Pharmacy",
      "definition" : "Doctor of Pharmacy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3622",
      "code" : "PHE",
      "display" : "Doctor of Engineering",
      "definition" : "Doctor of Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3623",
      "code" : "PHD",
      "display" : "Doctor of Philosophy",
      "definition" : "Doctor of Philosophy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3624",
      "code" : "PHS",
      "display" : "Doctor of Science",
      "definition" : "Doctor of Science",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3625",
      "code" : "MD",
      "display" : "Doctor of Medicine",
      "definition" : "Doctor of Medicine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3626",
      "code" : "DO",
      "display" : "Doctor of Osteopathy",
      "definition" : "Doctor of Osteopathy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3627",
      "code" : "EMT",
      "display" : "Emergency Medical Technician",
      "definition" : "Emergency Medical Technician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3628",
      "code" : "EMTP",
      "display" : "Emergency Medical Technician - Paramedic",
      "definition" : "Emergency Medical Technician - Paramedic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3629",
      "code" : "FPNP",
      "display" : "Family Practice Nurse Practitioner",
      "definition" : "Family Practice Nurse Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3630",
      "code" : "HS",
      "display" : "High School Graduate",
      "definition" : "High School Graduate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3631",
      "code" : "JD",
      "display" : "Juris Doctor",
      "definition" : "Juris Doctor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3632",
      "code" : "MA",
      "display" : "Master of Arts",
      "definition" : "Master of Arts",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3633",
      "code" : "MBA",
      "display" : "Master of Business Administration",
      "definition" : "Master of Business Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3634",
      "code" : "MCE",
      "display" : "Master of Civil Engineering",
      "definition" : "Master of Civil Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3635",
      "code" : "MDI",
      "display" : "Master of Divinity",
      "definition" : "Master of Divinity",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3636",
      "code" : "MED",
      "display" : "Master of Education",
      "definition" : "Master of Education",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3637",
      "code" : "MEE",
      "display" : "Master of Electrical Engineering",
      "definition" : "Master of Electrical Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3638",
      "code" : "ME",
      "display" : "Master of Engineering",
      "definition" : "Master of Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3639",
      "code" : "MFA",
      "display" : "Master of Fine Arts",
      "definition" : "Master of Fine Arts",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3640",
      "code" : "MME",
      "display" : "Master of Mechanical Engineering",
      "definition" : "Master of Mechanical Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3641",
      "code" : "MS",
      "display" : "Master of Science",
      "definition" : "Master of Science",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3642",
      "code" : "MSL",
      "display" : "Master of Science - Law",
      "definition" : "Master of Science - Law",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3643",
      "code" : "MSN",
      "display" : "Master of Science - Nursing",
      "definition" : "Master of Science - Nursing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3644",
      "code" : "MTH",
      "display" : "Master of Theology",
      "definition" : "Master of Theology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3645",
      "code" : "MDA",
      "display" : "Medical Assistant",
      "definition" : "Medical Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3646",
      "code" : "MT",
      "display" : "Medical Technician",
      "definition" : "Medical Technician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3647",
      "code" : "NG",
      "display" : "Non-Graduate",
      "definition" : "Non-Graduate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3648",
      "code" : "NP",
      "display" : "Nurse Practitioner",
      "definition" : "Nurse Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3649",
      "code" : "PA",
      "display" : "Physician Assistant",
      "definition" : "Physician Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3650",
      "code" : "RMA",
      "display" : "Registered Medical Assistant",
      "definition" : "Registered Medical Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3651",
      "code" : "RN",
      "display" : "Registered Nurse",
      "definition" : "Registered Nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3652",
      "code" : "RPH",
      "display" : "Registered Pharmacist",
      "definition" : "Registered Pharmacist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3653",
      "code" : "SEC",
      "display" : "Secretarial Certificate",
      "definition" : "Secretarial Certificate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3654",
      "code" : "TS",
      "display" : "Trade School Graduate",
      "definition" : "Trade School Graduate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
