# actionCodes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **actionCodes**

## CodeSystem: actionCodes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0323 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.196 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed. As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx. 

 
Underlying Master Code System for V2 table 0323 (Action Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSActionCode](ValueSet-v2-0323.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0323",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0323",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.196"
    }
  ],
  "version" : "2.0.0",
  "name" : "ActionCodes",
  "title" : "actionCodes",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed.  As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx.",
  "purpose" : "Underlying Master Code System for V2 table 0323 (Action Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0323",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "3036",
      "code" : "A",
      "display" : "Add/Insert",
      "definition" : "Add/Insert",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3037",
      "code" : "D",
      "display" : "Delete",
      "definition" : "Delete",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3038",
      "code" : "U",
      "display" : "Update",
      "definition" : "Update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3039",
      "code" : "X",
      "display" : "No change",
      "definition" : "No change",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
