# appointmentReason - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **appointmentReason**

## CodeSystem: appointmentReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0276 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AppointmentReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.169 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled. Used in HL7 Version 2.x messaging in the ARQ segment. 

 
Underlying Master Code System for V2 table 0276 (Appointment reason codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAppointmentReasonCodes](ValueSet-v2-0276.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0276",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0276",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.169"
    }
  ],
  "version" : "2.0.0",
  "name" : "AppointmentReason",
  "title" : "appointmentReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled.  Used in HL7 Version 2.x messaging in the ARQ segment.",
  "purpose" : "Underlying Master Code System for V2 table 0276 (Appointment reason codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0276",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2669",
      "code" : "ROUTINE",
      "display" : "Routine appointment - default if not valued",
      "definition" : "Routine appointment - default if not valued",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2670",
      "code" : "WALKIN",
      "display" : "A previously unscheduled walk-in visit",
      "definition" : "A previously unscheduled walk-in visit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2671",
      "code" : "CHECKUP",
      "display" : "A routine check-up, such as an annual physical",
      "definition" : "A routine check-up, such as an annual physical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2672",
      "code" : "FOLLOWUP",
      "display" : "A follow up visit from a previous appointment",
      "definition" : "A follow up visit from a previous appointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2673",
      "code" : "EMERGENCY",
      "display" : "Emergency appointment",
      "definition" : "Emergency appointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
