# date-timeSelectionQualifier - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **date-timeSelectionQualifier**

## CodeSystem: date-timeSelectionQualifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0158 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DateTimeSelectionQualifier |
| *Other Identifiers:*OID:2.16.840.1.113883.18.76 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment. 

 
Underlying Master Code System for V2 table 0158 (Date/time selection qualifier) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDateTimeSelectionQualifier](ValueSet-v2-0158.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0158",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0158",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.76"
    }
  ],
  "version" : "2.0.0",
  "name" : "DateTimeSelectionQualifier",
  "title" : "date-timeSelectionQualifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment.",
  "purpose" : "Underlying Master Code System for V2 table 0158 (Date/time selection qualifier)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0158",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "1653",
      "code" : "1ST",
      "display" : "First value within range",
      "definition" : "First value within range",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "erster Wert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1654",
      "code" : "ALL",
      "display" : "All values within the range",
      "definition" : "All values within the range",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "alle Werte"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1655",
      "code" : "LST",
      "display" : "Last value within the range",
      "definition" : "Last value within the range",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "letzter Wert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1656",
      "code" : "REV",
      "display" : "All values within the range returned in reverse chronological order (This is the default if not otherwise specified.)",
      "definition" : "All values within the range returned in reverse chronological order (This is the default if not otherwise specified.)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "alle Werte in umgekehrter chronologischer Reihenfolge"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
