# Test script profile destination type - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Test script profile destination type**

## CodeSystem: Test script profile destination type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/testscript-profile-destination-types | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TestScriptProfileDestinationType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1197 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TestScriptProfileDestinationType](ValueSet-testscript-profile-destination-types.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "testscript-profile-destination-types",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/testscript-profile-destination-types",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1197"
    }
  ],
  "version" : "1.0.1",
  "name" : "TestScriptProfileDestinationType",
  "title" : "Test script profile destination type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/testscript-profile-destination-types",
  "content" : "complete",
  "concept" : [
    {
      "code" : "FHIR-Server",
      "display" : "FHIR Server",
      "definition" : "General FHIR server used to respond to operations sent from a FHIR client."
    },
    {
      "code" : "FHIR-SDC-FormManager",
      "display" : "FHIR SDC FormManager",
      "definition" : "A FHIR server acting as a Structured Data Capture Form Manager."
    },
    {
      "code" : "FHIR-SDC-FormProcessor",
      "display" : "FHIR SDC FormProcessor",
      "definition" : "A FHIR server acting as a Structured Data Capture Form Processor."
    },
    {
      "code" : "FHIR-SDC-FormReceiver",
      "display" : "FHIR SDC FormReceiver",
      "definition" : "A FHIR server acting as a Structured Data Capture Form Receiver."
    }
  ]
}

```
