# PayeeResourceType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PayeeResourceType**

## CodeSystem: PayeeResourceType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/resource-type-link | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PayeeResourceType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1180 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The type of payee Resource. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PayeeResourceType](ValueSet-resource-type-link.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "resource-type-link",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/resource-type-link",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1180"
    }
  ],
  "version" : "1.0.0",
  "name" : "PayeeResourceType",
  "title" : "PayeeResourceType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of payee Resource.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/resource-type-link",
  "content" : "complete",
  "concept" : [
    {
      "code" : "organization",
      "display" : "Organization",
      "definition" : "Organization resource."
    },
    {
      "code" : "patient",
      "display" : "Patient",
      "definition" : "Patient resource."
    },
    {
      "code" : "practitioner",
      "display" : "Practitioner",
      "definition" : "Practitioner resource."
    },
    {
      "code" : "relatedperson",
      "display" : "RelatedPerson",
      "definition" : "RelatedPerson resource."
    }
  ]
}

```
