# ResearchSubjectState - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchSubjectState**

## CodeSystem: ResearchSubjectState 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-subject-state | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchSubjectState |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Indicates the progression of a study subject through a study. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchSubjectState](ValueSet-research-subject-state.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-subject-state",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-subject-state",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.1",
  "name" : "ResearchSubjectState",
  "title" : "ResearchSubjectState",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the progression of a study subject through a study.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-subject-state",
  "content" : "complete",
  "concept" : [
    {
      "code" : "candidate",
      "display" : "Candidate",
      "definition" : "An identified person that can be considered for inclusion in a study."
    },
    {
      "code" : "eligible",
      "display" : "Eligible",
      "definition" : "A person that has met the eligibility criteria for inclusion in a study."
    },
    {
      "code" : "follow-up",
      "display" : "Follow-up",
      "definition" : "A person is no longer receiving study intervention and/or being evaluated with tests and procedures according to the protocol, but they are being monitored on a protocol-prescribed schedule."
    },
    {
      "code" : "ineligible",
      "display" : "Ineligible",
      "definition" : "A person who did not meet one or more criteria required for participation in a study is considered to have failed screening or\nis ineligible for the study."
    },
    {
      "code" : "not-registered",
      "display" : "Not Registered",
      "definition" : "A person for whom registration was not completed."
    },
    {
      "code" : "off-study",
      "display" : "Off-study",
      "definition" : "A person that has ended their participation on a study either because their treatment/observation is complete or through not\nresponding, withdrawal, non-compliance and/or adverse event."
    },
    {
      "code" : "on-study",
      "display" : "On-study",
      "definition" : "A person that is enrolled or registered on a study."
    },
    {
      "code" : "on-study-intervention",
      "display" : "On-study-intervention",
      "definition" : "The person is receiving the treatment or participating in an activity (e.g. yoga, diet, etc.) that the study is evaluating."
    },
    {
      "code" : "on-study-observation",
      "display" : "On-study-observation",
      "definition" : "The subject is being evaluated via tests and assessments according to the study calendar, but is not receiving any intervention. Note that this state is study-dependent and might not exist in all studies.  A synonym for this is \"short-term follow-up\"."
    },
    {
      "code" : "pending-on-study",
      "display" : "Pending on-study",
      "definition" : "A person is pre-registered for a study."
    },
    {
      "code" : "potential-candidate",
      "display" : "Potential Candidate",
      "definition" : "A person that is potentially eligible for participation in the study."
    },
    {
      "code" : "screening",
      "display" : "Screening",
      "definition" : "A person who is being evaluated for eligibility for a study."
    },
    {
      "code" : "withdrawn",
      "display" : "Withdrawn",
      "definition" : "The person has withdrawn their participation in the study before registration."
    }
  ]
}

```
