# MedicationRequest Status Reason Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Status Reason Codes**

## CodeSystem: MedicationRequest Status Reason Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationRequestStatusReasonCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1325 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationRequest Status Reason Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationRequestStatusReasonCodes](ValueSet-medicationrequest-status-reason.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationrequest-status-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1325"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationRequestStatusReasonCodes",
  "title" : "MedicationRequest Status Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationRequest Status Reason Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationrequest-status-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "altchoice",
      "display" : "Try another treatment first",
      "definition" : "This therapy has been ordered as a backup to a preferred therapy. This order will be released when and if the preferred therapy is unsuccessful."
    },
    {
      "code" : "clarif",
      "display" : "Prescription requires clarification",
      "definition" : "Clarification is required before the order can be acted upon."
    },
    {
      "code" : "drughigh",
      "display" : "Drug level too high",
      "definition" : "The current level of the medication in the patient's system is too high. The medication is suspended to allow the level to subside to a safer level."
    },
    {
      "code" : "hospadm",
      "display" : "Admission to hospital",
      "definition" : "The patient has been admitted to a care facility and their community medications are suspended until hospital discharge."
    },
    {
      "code" : "labint",
      "display" : "Lab interference issues",
      "definition" : "The therapy would interfere with a planned lab test and the therapy is being withdrawn until the test is completed."
    },
    {
      "code" : "non-avail",
      "display" : "Patient not available",
      "definition" : "Patient not available for a period of time due to a scheduled therapy, leave of absence or other reason."
    },
    {
      "code" : "preg",
      "display" : "Parent is pregnant/breast feeding",
      "definition" : "The patient is pregnant or breast feeding. The therapy will be resumed when the pregnancy is complete and the patient is no longer breastfeeding."
    },
    {
      "code" : "salg",
      "display" : "Allergy",
      "definition" : "The patient is believed to be allergic to a substance that is part of the therapy and the therapy is being temporarily withdrawn to confirm."
    },
    {
      "code" : "sddi",
      "display" : "Drug interacts with another drug",
      "definition" : "The drug interacts with a short-term treatment that is more urgently required. This order will be resumed when the short-term treatment is complete."
    },
    {
      "code" : "sdupther",
      "display" : "Duplicate therapy",
      "definition" : "The drug interacts with a short-term treatment that is more urgently required. This order will be resumed when the short-term treatment is complete."
    },
    {
      "code" : "sintol",
      "display" : "Suspected intolerance",
      "definition" : "The drug interacts with a short-term treatment that is more urgently required. This order will be resumed when the short-term treatment is complete."
    },
    {
      "code" : "surg",
      "display" : "Patient scheduled for surgery.",
      "definition" : "The drug is contraindicated for patients receiving surgery and the patient is scheduled to be admitted for surgery in the near future. The drug will be resumed when the patient has sufficiently recovered from the surgery."
    },
    {
      "code" : "washout",
      "display" : "Waiting for old drug to wash out",
      "definition" : "The patient was previously receiving a medication contraindicated with the current medication. The current medication will remain on hold until the prior medication has been cleansed from their system."
    }
  ]
}

```
