# Measure Supplemental Data - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Supplemental Data**

## CodeSystem: Measure Supplemental Data 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-supplemental-data | *Version*:3.0.0 | |
| Active as of 2023-02-06 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureSupplementalData |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifier supplemental data in a population for measuring purposes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureSupplementalData](ValueSet-measure-supplemental-data.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-supplemental-data",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-supplemental-data",
  "version" : "3.0.0",
  "name" : "MeasureSupplementalData",
  "title" : "Measure Supplemental Data",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-02-06T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifier supplemental data in a population for measuring purposes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "age",
      "display" : "Age",
      "definition" : "Age Supplemental Data."
    },
    {
      "code" : "gender",
      "display" : "Gender",
      "definition" : "Gender Supplemental Data."
    },
    {
      "code" : "ethnicity",
      "display" : "Ethnicity",
      "definition" : "Ethnicity Supplemental Data."
    },
    {
      "code" : "payer",
      "display" : "Payer",
      "definition" : "Payer Supplemental Data."
    },
    {
      "code" : "race",
      "display" : "Race",
      "definition" : "Race Supplemental Data."
    }
  ]
}

```
