# MatchGrade - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MatchGrade**

## CodeSystem: MatchGrade 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/match-grade | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MatchGrade |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1289 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MatchGrade](ValueSet-match-grade.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "match-grade",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/match-grade",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1289"
    }
  ],
  "version" : "1.0.0",
  "name" : "MatchGrade",
  "title" : "MatchGrade",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/match-grade",
  "content" : "complete",
  "concept" : [
    {
      "code" : "certain",
      "display" : "Certain Match",
      "definition" : "This record meets the matching criteria to be automatically considered as a full match."
    },
    {
      "code" : "probable",
      "display" : "Probable Match",
      "definition" : "This record is a close match, but not a certain match. Additional review (e.g. by a human) may be required before using this as a match."
    },
    {
      "code" : "possible",
      "display" : "Possible Match",
      "definition" : "This record may be a matching one. Additional review (e.g. by a human) SHOULD be performed before using this as a match."
    },
    {
      "code" : "certainly-not",
      "display" : "Certainly Not a Match",
      "definition" : "This record is known not to be a match. Note that usually non-matching records are not returned, but in some cases records previously or likely considered as a match may specifically be negated by the matching engine."
    }
  ]
}

```
