# Example Revenue Center Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Revenue Center Codes**

## CodeSystem: Example Revenue Center Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-revenue-center | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleRevenueCenterCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1168 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Revenue Center codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleRevenueCenterCodes](ValueSet-ex-revenue-center.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-revenue-center",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-revenue-center",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1168"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleRevenueCenterCodes",
  "title" : "Example Revenue Center Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Revenue Center codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-revenue-center",
  "content" : "complete",
  "concept" : [
    {
      "code" : "0010",
      "display" : "Vision Clinic",
      "definition" : "Vision Office or Clinic."
    },
    {
      "code" : "0011",
      "display" : "Dental Clinic",
      "definition" : "Dental Office or Clinic."
    },
    {
      "code" : "1001",
      "display" : "Emergency",
      "definition" : "Emergency Department."
    }
  ]
}

```
