# Diet - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diet**

## CodeSystem: Diet 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/diet | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Diet |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1091 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Diet](ValueSet-encounter-diet.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "diet",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/diet",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1091"
    }
  ],
  "version" : "1.0.1",
  "name" : "Diet",
  "title" : "Diet",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/encounter-diet",
  "content" : "complete",
  "concept" : [
    {
      "code" : "vegetarian",
      "display" : "Vegetarian",
      "definition" : "Food without meat, poultry or seafood."
    },
    {
      "code" : "dairy-free",
      "display" : "Dairy Free",
      "definition" : "Excludes dairy products."
    },
    {
      "code" : "nut-free",
      "display" : "Nut Free",
      "definition" : "Excludes ingredients containing nuts."
    },
    {
      "code" : "gluten-free",
      "display" : "Gluten Free",
      "definition" : "Excludes ingredients containing gluten."
    },
    {
      "code" : "vegan",
      "display" : "Vegan",
      "definition" : "Food without meat, poultry, seafood, eggs, dairy products and other animal-derived substances."
    },
    {
      "code" : "halal",
      "display" : "Halal",
      "definition" : "Foods that conform to Islamic law."
    },
    {
      "code" : "kosher",
      "display" : "Kosher",
      "definition" : "Foods that conform to Jewish dietary law."
    }
  ]
}

```
