# DICOM Audit Message Record Lifecycle Events - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DICOM Audit Message Record Lifecycle Events**

## CodeSystem: DICOM Audit Message Record Lifecycle Events 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/dicom-audit-lifecycle | *Version*:2.0.0 | |
| Active as of 2025-11-12 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DicomAuditMessageRecordLifecycleEvents |
| **Copyright/Legal**: These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association. | | |

 
Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message, 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "dicom-audit-lifecycle",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/dicom-audit-lifecycle",
  "version" : "2.0.0",
  "name" : "DicomAuditMessageRecordLifecycleEvents",
  "title" : "DICOM Audit Message Record Lifecycle Events",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message, ",
  "copyright" : "These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "Origination / Creation"
    },
    {
      "code" : "2",
      "display" : "Import / Copy"
    },
    {
      "code" : "3",
      "display" : "Amendment"
    },
    {
      "code" : "4",
      "display" : "Verification"
    },
    {
      "code" : "5",
      "display" : "Translation"
    },
    {
      "code" : "6",
      "display" : "Access / Use"
    },
    {
      "code" : "7",
      "display" : "De-identification"
    },
    {
      "code" : "8",
      "display" : "Aggregation / summarization / derivation"
    },
    {
      "code" : "9",
      "display" : "Report"
    },
    {
      "code" : "10",
      "display" : "Export"
    },
    {
      "code" : "11",
      "display" : "Disclosure"
    },
    {
      "code" : "12",
      "display" : "Receipt of disclosure"
    },
    {
      "code" : "13",
      "display" : "Archiving"
    },
    {
      "code" : "14",
      "display" : "Logical deletion"
    },
    {
      "code" : "15",
      "display" : "Permanent erasure / Physical destruction"
    }
  ]
}

```
