# ContainerCap - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ContainerCap**

## CodeSystem: ContainerCap 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/container-cap | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContainerCap |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1258 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Color of the container cap. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContainerCap](ValueSet-container-cap.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "container-cap",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/container-cap",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1258"
    }
  ],
  "version" : "1.0.1",
  "name" : "ContainerCap",
  "title" : "ContainerCap",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Color of the container cap.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/container-cap",
  "content" : "complete",
  "concept" : [
    {
      "code" : "red",
      "display" : "red cap",
      "definition" : "red cap."
    },
    {
      "code" : "yellow",
      "display" : "yellow cap",
      "definition" : "yellow cap."
    },
    {
      "code" : "dark-yellow",
      "display" : "dark yellow cap",
      "definition" : "dark yellow cap."
    },
    {
      "code" : "grey",
      "display" : "grey cap",
      "definition" : "grey cap."
    },
    {
      "code" : "light-blue",
      "display" : "light blue cap",
      "definition" : "light blue cap."
    },
    {
      "code" : "black",
      "display" : "black cap",
      "definition" : "black cap."
    },
    {
      "code" : "green",
      "display" : "green cap",
      "definition" : "green cap."
    },
    {
      "code" : "light-green",
      "display" : "light green cap",
      "definition" : "light green cap."
    },
    {
      "code" : "lavender",
      "display" : "lavender cap",
      "definition" : "lavender cap."
    },
    {
      "code" : "brown",
      "display" : "brown cap",
      "definition" : "brown cap."
    },
    {
      "code" : "white",
      "display" : "white cap",
      "definition" : "white cap."
    },
    {
      "code" : "pink",
      "display" : "pink cap",
      "definition" : "pink cap."
    }
  ]
}

```
