# Claim Type Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Claim Type Codes**

## CodeSystem: Claim Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/claim-type | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ClaimTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1156 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes Claim Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ClaimTypeCodes](ValueSet-claim-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "claim-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/claim-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1156"
    }
  ],
  "version" : "1.0.1",
  "name" : "ClaimTypeCodes",
  "title" : "Claim Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Claim Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/claim-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "institutional",
      "display" : "Institutional",
      "definition" : "Hospital, clinic and typically inpatient claims."
    },
    {
      "code" : "oral",
      "display" : "Oral",
      "definition" : "Dental, Denture and Hygiene claims."
    },
    {
      "code" : "pharmacy",
      "display" : "Pharmacy",
      "definition" : "Pharmacy claims for goods and services."
    },
    {
      "code" : "professional",
      "display" : "Professional",
      "definition" : "Typically, outpatient claims from Physician, Psychological, Chiropractor, Physiotherapy, Speech Pathology, rehabilitative, consulting."
    },
    {
      "code" : "vision",
      "display" : "Vision",
      "definition" : "Vision claims for professional services and products such as glasses and contact lenses."
    }
  ]
}

```
