# StatisticCertaintySubcomponentType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticCertaintySubcomponentType**

## CodeSystem: StatisticCertaintySubcomponentType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/certainty-subcomponent-type | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticCertaintySubcomponentType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1360 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The subcomponent classification of quality of evidence rating systems. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticCertaintySubcomponentType](ValueSet-certainty-subcomponent-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "certainty-subcomponent-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/certainty-subcomponent-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1360"
    }
  ],
  "version" : "1.0.0",
  "name" : "StatisticCertaintySubcomponentType",
  "title" : "StatisticCertaintySubcomponentType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The subcomponent classification of quality of evidence rating systems.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/certainty-subcomponent-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "RiskOfBias",
      "display" : "Risk of bias",
      "definition" : "methodologic concerns reducing internal validity."
    },
    {
      "code" : "Inconsistency",
      "display" : "Inconsistency",
      "definition" : "concerns that findings are not similar enough to support certainty."
    },
    {
      "code" : "Indirectness",
      "display" : "Indirectness",
      "definition" : "concerns reducing external validity."
    },
    {
      "code" : "Imprecision",
      "display" : "Imprecision",
      "definition" : "fuzzy or wide variability."
    },
    {
      "code" : "PublicationBias",
      "display" : "Publication bias",
      "definition" : "likelihood that what is published misrepresents what is available to publish."
    },
    {
      "code" : "DoseResponseGradient",
      "display" : "Dose response gradient",
      "definition" : "higher certainty due to dose response relationship."
    },
    {
      "code" : "PlausibleConfounding",
      "display" : "Plausible confounding",
      "definition" : "higher certainty due to risk of bias in opposite direction."
    },
    {
      "code" : "LargeEffect",
      "display" : "Large effect",
      "definition" : "higher certainty due to large effect size."
    }
  ]
}

```
