# AllergyIntolerance Verification Status - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance Verification Status**

## CodeSystem: AllergyIntolerance Verification Status 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/allergyintolerance-verification | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AllergyIntoleranceVerificationStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1371 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The verification status to support or decline the clinical status of the allergy or intolerance. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AllergyIntoleranceVerificationStatus](ValueSet-allergyintolerance-verification.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allergyintolerance-verification",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1371"
    }
  ],
  "version" : "1.0.1",
  "name" : "AllergyIntoleranceVerificationStatus",
  "title" : "AllergyIntolerance Verification Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The verification status to support or decline the clinical status of the allergy or intolerance.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/allergyintolerance-verification",
  "content" : "complete",
  "concept" : [
    {
      "code" : "unconfirmed",
      "display" : "Unconfirmed",
      "definition" : "The propensity for a reaction to the identified substance has not been objectively verified.",
      "concept" : [
        {
          "code" : "presumed",
          "display" : "Presumed",
          "definition" : "The available clinical information supports a high liklihood of the propensity for a reaction to the identified substance."
        }
      ]
    },
    {
      "code" : "confirmed",
      "display" : "Confirmed",
      "definition" : "The propensity for a reaction to the identified substance has been objectively verified (which may include clinical evidence by testing, rechallenge, or observation)."
    },
    {
      "code" : "refuted",
      "display" : "Refuted",
      "definition" : "A propensity for a reaction to the identified substance has been disputed or disproven with a sufficient level of clinical certainty to justify invalidating the assertion. This might or might not include testing or rechallenge."
    },
    {
      "code" : "entered-in-error",
      "display" : "Entered in Error",
      "definition" : "The statement was entered in error and is not valid."
    }
  ]
}

```
