# AdverseEventSeriousness - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdverseEventSeriousness**

## CodeSystem: AdverseEventSeriousness 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adverse-event-seriousness | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventSeriousness |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1253 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Overall seriousness of this event for the patient. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdverseEventSeriousness](ValueSet-adverse-event-seriousness.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adverse-event-seriousness",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adverse-event-seriousness",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1253"
    }
  ],
  "version" : "1.0.1",
  "name" : "AdverseEventSeriousness",
  "title" : "AdverseEventSeriousness",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Overall seriousness of this event for the patient.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adverse-event-seriousness",
  "content" : "complete",
  "concept" : [
    {
      "code" : "non-serious",
      "display" : "Non-serious",
      "definition" : "This event is considered not to have the potential for persistent or costly injury or consequence."
    },
    {
      "code" : "serious",
      "display" : "Serious",
      "definition" : "This event is considered to have the potential for persistent or costly injury or consequence."
    }
  ]
}

```
