# AdverseEventCausalityAssessment - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdverseEventCausalityAssessment**

## CodeSystem: AdverseEventCausalityAssessment 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adverse-event-causality-assess | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventCausalityAssessment |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1254 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes for the assessment of whether the entity caused the event. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdverseEventCausalityAssessment](ValueSet-adverse-event-causality-assess.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adverse-event-causality-assess",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adverse-event-causality-assess",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1254"
    }
  ],
  "version" : "1.0.1",
  "name" : "AdverseEventCausalityAssessment",
  "title" : "AdverseEventCausalityAssessment",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the assessment of whether the entity caused the event.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adverse-event-causality-assess",
  "content" : "complete",
  "concept" : [
    {
      "code" : "certain",
      "display" : "Certain",
      "definition" : "i) Event or laboratory test abnormality, with plausible time relationship to drug intake; ii) Cannot be explained by disease or other drugs; iii) Response to withdrawal plausible (pharmacologically, pathologically); iv) Event definitive pharmacologically or phenomenologically (i.e. an objective and specific medical disorder or a recognized pharmacological phenomenon); or v) Re-challenge satisfactory, if necessary."
    },
    {
      "code" : "probably-likely",
      "display" : "Probably/Likely",
      "definition" : "i) Event or laboratory test abnormality, with reasonable time relationship to drug intake; ii) Unlikely to be attributed to disease or other drugs; iii) Response to withdrawal clinically reasonable; or iv) Re-challenge not required."
    },
    {
      "code" : "possible",
      "display" : "Possible",
      "definition" : "i) Event or laboratory test abnormality, with reasonable time relationship to drug intake; ii) Could also be explained by disease or other drugs; or iii) Information on drug withdrawal may be lacking or unclear."
    },
    {
      "code" : "unlikely",
      "display" : "Unlikely",
      "definition" : "i) Event or laboratory test abnormality, with a time to drug intake that makes a relationship improbable (but not impossible); or ii) Disease or other drugs provide plausible explanations."
    },
    {
      "code" : "conditional-classified",
      "display" : "Conditional/Classified",
      "definition" : "i) Event or laboratory test abnormality; ii) More data for proper assessment needed; or iii) Additional data under examination."
    },
    {
      "code" : "unassessable-unclassifiable",
      "display" : "Unassessable/Unclassifiable",
      "definition" : "i) Report suggesting an adverse reaction; ii) Cannot be judged because information is insufficient or contradictory; or iii) Data cannot be supplemented or verified."
    }
  ]
}

```
