# ActionType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActionType**

## CodeSystem: ActionType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/action-type | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActionType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1246 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The type of action to be performed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActionType](ValueSet-action-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "action-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/action-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1246"
    }
  ],
  "version" : "1.0.1",
  "name" : "ActionType",
  "title" : "ActionType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of action to be performed.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/action-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "create",
      "display" : "Create",
      "definition" : "The action is to create a new resource."
    },
    {
      "code" : "update",
      "display" : "Update",
      "definition" : "The action is to update an existing resource."
    },
    {
      "code" : "remove",
      "display" : "Remove",
      "definition" : "The action is to remove an existing resource."
    },
    {
      "code" : "fire-event",
      "display" : "Fire Event",
      "definition" : "The action is to fire a specific event."
    }
  ]
}

```
