# V2 Value Sets - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Value Sets**](valuesets.md)
* **V2 Value Sets**

## V2 Value Sets

 Value Sets defined and maintaineed by HL7, and published as part of the Version 2 familly of International Standards. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [v2-0001](ValueSet-v2-0001.md)
  * Name: hl7VS-administrativeSex
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying a patient's sex for administrative purposes.
* Identity: [v2-0002](ValueSet-v2-0002.md)
  * Name: hl7VS-maritalStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a person's marital (civil/legal) status.
* Identity: [v2-0003](ValueSet-v2-0003.md)
  * Name: hl7VS-eventTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying the trigger event for Version 2.x interface messages.
* Identity: [v2-0004](ValueSet-v2-0004.md)
  * Name: hl7VS-patientClass
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts used by systems to categorize patients by sites.
* Identity: [v2-0005](ValueSet-v2-0005.md)
  * Name: PHVS_Race_HL7_2x
  * Version: 4.0.0
  * Status: active
  * Owner: HL7
  * Copyright: THO
  * Date: 2021-09-01
  * Description: This race value set is based upon CDC check-digit codes, but using the HL7 table 0005. HL7 adopted …
* Identity: [v2-0006](ValueSet-v2-0006.md)
  * Name: hl7VS-religion2
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a person's religion.
* Identity: [v2-0007](ValueSet-v2-0007.md)
  * Name: hl7VS-admissionType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the circumstances under which the patient was or will be admitted.
* Identity: [v2-0008](ValueSet-v2-0008.md)
  * Name: hl7VS-acknowledgmentCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see me…
* Identity: [v2-0009](ValueSet-v2-0009.md)
  * Name: hl7VS-ambulatoryStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify permanent or transient handicapped conditions of a person.
* Identity: [v2-0012](ValueSet-v2-0012.md)
  * Name: hl7VS-stockLocation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a stock location.
* Identity: [v2-0017](ValueSet-v2-0017.md)
  * Name: hl7VS-transactionType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a type of financial transaction.
* Identity: [v2-0027](ValueSet-v2-0027.md)
  * Name: hl7VS-priority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the allowed priorities for obtaining the specimen.
* Identity: [v2-0033](ValueSet-v2-0033.md)
  * Name: hl7VS-route
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that are used to indicate a means of administrating a medication dose.
* Identity: [v2-0034](ValueSet-v2-0034.md)
  * Name: hl7VS-siteAdministered
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a location on the body where a dose is to be administered, e.g., IV…
* Identity: [v2-0038](ValueSet-v2-0038.md)
  * Name: hl7VS-orderStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of an order. The purpose of these values are to report t…
* Identity: [v2-0048](ValueSet-v2-0048.md)
  * Name: hl7VS-whatSubjectFilter
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify the kind of information that is required to satisfy a query reques…
* Identity: [v2-0052](ValueSet-v2-0052.md)
  * Name: hl7VS-diagnosisType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying a type of diagnosis being sent in HL7 Version 2.x messages.
* Identity: [v2-0061](ValueSet-v2-0061.md)
  * Name: hl7VS-checkDigitScheme
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts used to identify the check digit scheme employed when a check digit is used in various HL7…
* Identity: [v2-0062](ValueSet-v2-0062.md)
  * Name: hl7VS-eventReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason for an event.
* Identity: [v2-0063](ValueSet-v2-0063.md)
  * Name: hl7VS-relationship
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying an actual personal relationship that the next of kin/associated party has to a …
* Identity: [v2-0065](ValueSet-v2-0065.md)
  * Name: hl7VS-actionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify actions to be taken with respect to the specimens that accompany or precede …
* Identity: [v2-0066](ValueSet-v2-0066.md)
  * Name: hl7VS-employmentStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the guarantor's employment status.
* Identity: [v2-0069](ValueSet-v2-0069.md)
  * Name: hl7VS-hospitalService
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the treatment or type of surgery the patient is scheduled to receiv…
* Identity: [v2-0070](ValueSet-v2-0070.md)
  * Name: hl7VS-sourceOfSpecimen
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify sources for speciments for clinical testing. These concepts are u…
* Identity: [v2-0074](ValueSet-v2-0074.md)
  * Name: hl7VS-diagnosticServiceSectionId
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify a section of a diagnostic service where the observation may be performed.
* Identity: [v2-0076](ValueSet-v2-0076.md)
  * Name: hl7VS-messageType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify message types for HL7 Version 2.x messaging.
* Identity: [v2-0080](ValueSet-v2-0080.md)
  * Name: hl7VS-natureOfAbnormalTesting
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the nature of an abnormal test.
* Identity: [v2-0083](ValueSet-v2-0083.md)
  * Name: hl7VS-outlierType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of outlier (i.e. period of care beyond DRG-standard stay i…
* Identity: [v2-0085](ValueSet-v2-0085.md)
  * Name: hl7VS-observationResultStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify observation result status. These codes reflect the current completion status…
* Identity: [v2-0091](ValueSet-v2-0091.md)
  * Name: hl7VS-queryPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify a time frame in which a querry response is expected.
* Identity: [v2-0092](ValueSet-v2-0092.md)
  * Name: hl7VS-re-admissionIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which are used to specify that a patient is being re-admitted to a healthcare fa…
* Identity: [v2-0098](ValueSet-v2-0098.md)
  * Name: hl7VS-typeOfAgreement
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify codes to further identify an insurance plan.
* Identity: [v2-0100](ValueSet-v2-0100.md)
  * Name: hl7VS-whenToCharge
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify codes for an event precipitating/triggering a charge activity.
* Identity: [v2-0102](ValueSet-v2-0102.md)
  * Name: hl7VS-delayedAcknowledgmentType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify a response type used in deferred processing two phase reply for delayed ackn…
* Identity: [v2-0103](ValueSet-v2-0103.md)
  * Name: hl7VS-processingId
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the message is part of a production, training or debugging …
* Identity: [v2-0104](ValueSet-v2-0104.md)
  * Name: hl7VS-versionControlTable
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which are used to identify an HL7 version in the Version 2.x family of published standards.
* Identity: [v2-0105](ValueSet-v2-0105.md)
  * Name: hl7VS-sourceOfComment
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in…
* Identity: [v2-0106](ValueSet-v2-0106.md)
  * Name: hl7VS-queryFormatCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify which of several types of formats for data to be returned in respo…
* Identity: [v2-0107](ValueSet-v2-0107.md)
  * Name: hl7VS-deferredResponseType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify which type of deferred query resonse is desired, as specified with…
* Identity: [v2-0108](ValueSet-v2-0108.md)
  * Name: hl7VS-queryResultsLevel
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which are used to control level of detail in query results.
* Identity: [v2-0109](ValueSet-v2-0109.md)
  * Name: hl7VS-reportPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify the priority associated with a report or update run using a query.
* Identity: [v2-0116](ValueSet-v2-0116.md)
  * Name: hl7VS-bedStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determin…
* Identity: [v2-0119](ValueSet-v2-0119.md)
  * Name: hl7VS-orderControl
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which are used to determine the function of the order segment. Depending on the message, …
* Identity: [v2-0121](ValueSet-v2-0121.md)
  * Name: hl7VS-responseFlag
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes allowing the placer (sending) application to determine the amount of information…
* Identity: [v2-0122](ValueSet-v2-0122.md)
  * Name: hl7VS-chargeType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify someone or something other than the patient to be billed for a serv…
* Identity: [v2-0123](ValueSet-v2-0123.md)
  * Name: hl7VS-resultStatus-Obr
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the …
* Identity: [v2-0124](ValueSet-v2-0124.md)
  * Name: hl7VS-transportationMode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an or…
* Identity: [v2-0125](ValueSet-v2-0125.md)
  * Name: hl7VS-valueType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify the data type of OBX-5, Observation Value, and are a subset of the datatypes…
* Identity: [v2-0126](ValueSet-v2-0126.md)
  * Name: hl7VS-quantityLimitedRequest
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify the maximum length of a query response that can be accepted by a requesting …
* Identity: [v2-0127](ValueSet-v2-0127.md)
  * Name: hl7VS-allergyType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify classification of general allergy categories (drug, food, pollen, …
* Identity: [v2-0128](ValueSet-v2-0128.md)
  * Name: hl7VS-allergySeverity
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the general severity of an allergy.
* Identity: [v2-0130](ValueSet-v2-0130.md)
  * Name: hl7VS-visitUserCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify categories of a patient's visit with respect to an individual insti…
* Identity: [v2-0131](ValueSet-v2-0131.md)
  * Name: hl7VS-contactRole2
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which specify a relationship role that the next of kin/associated parties plays with regar…
* Identity: [v2-0133](ValueSet-v2-0133.md)
  * Name: hl7VS-procedurePractitionerType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes of concepts which specify the different types of practitioners associated with t…
* Identity: [v2-0135](ValueSet-v2-0135.md)
  * Name: hl7VS-assignmentOfBenefits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits…
* Identity: [v2-0136](ValueSet-v2-0136.md)
  * Name: hl7VS-yes-no-Indicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Codes specifying either Yes or No used in fields containing binary answers generally user-specified.
* Identity: [v2-0137](ValueSet-v2-0137.md)
  * Name: hl7VS-mailClaimParty
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a party to which a claim should be mailed when claims are sent by m…
* Identity: [v2-0140](ValueSet-v2-0140.md)
  * Name: hl7VS-militaryService
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the military branch. This field is defined by CMS or other regulat…
* Identity: [v2-0142](ValueSet-v2-0142.md)
  * Name: hl7VS-militaryStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the military status of the patient. This field is defined by CMS o…
* Identity: [v2-0144](ValueSet-v2-0144.md)
  * Name: hl7VS-eligibilitySource
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the source of information about the insured's eligibility for benef…
* Identity: [v2-0145](ValueSet-v2-0145.md)
  * Name: hl7VS-roomType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the room type.
* Identity: [v2-0146](ValueSet-v2-0146.md)
  * Name: hl7VS-amountType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify amount quantity type.
* Identity: [v2-0147](ValueSet-v2-0147.md)
  * Name: hl7VS-policyType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the policy type.
* Identity: [v2-0148](ValueSet-v2-0148.md)
  * Name: hl7VS-penaltyType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the amount is currency or a percentage.
* Identity: [v2-0149](ValueSet-v2-0149.md)
  * Name: hl7VS-dayType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the days are denied, pending or approved.
* Identity: [v2-0150](ValueSet-v2-0150.md)
  * Name: hl7VS-precertificationPatientType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the category or type of patient for which this certification is req…
* Identity: [v2-0155](ValueSet-v2-0155.md)
  * Name: hl7VS-accept-applicationAcknowledgmentConditions
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which identify conditions under which accept acknowledgments are required to be returned i…
* Identity: [v2-0156](ValueSet-v2-0156.md)
  * Name: hl7VS-whichDate-timeQualifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of date referred to in the other date fields in the QRF se…
* Identity: [v2-0157](ValueSet-v2-0157.md)
  * Name: hl7VS-whichDate-timeStatusQualifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status type of objects selected in date range defined by QRF-2 …
* Identity: [v2-0158](ValueSet-v2-0158.md)
  * Name: hl7VS-date-timeSelectionQualifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that allow the specification of certain types of values within the date/time ran…
* Identity: [v2-0159](ValueSet-v2-0159.md)
  * Name: hl7VS-dietType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of diet.
* Identity: [v2-0160](ValueSet-v2-0160.md)
  * Name: hl7VS-trayType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of dietary tray.
* Identity: [v2-0161](ValueSet-v2-0161.md)
  * Name: hl7VS-allowSubstitution
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitut…
* Identity: [v2-0162](ValueSet-v2-0162.md)
  * Name: hl7VS-routeOfAdministration
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the route of administration.
* Identity: [v2-0163](ValueSet-v2-0163.md)
  * Name: hl7VS-administriveSite
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that specify a body site from which a specimen is obtained.
* Identity: [v2-0164](ValueSet-v2-0164.md)
  * Name: hl7VS-administrationDevice
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the mechanical device used to aid in the administration of the drug…
* Identity: [v2-0165](ValueSet-v2-0165.md)
  * Name: hl7VS-administrationMethod
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the specific method requested for the administration of the drug or…
* Identity: [v2-0166](ValueSet-v2-0166.md)
  * Name: hl7VS-rxComponentType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the RX component type.
* Identity: [v2-0167](ValueSet-v2-0167.md)
  * Name: hl7VS-substitutionStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the substitution status.
* Identity: [v2-0168](ValueSet-v2-0168.md)
  * Name: hl7VS-processingPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify one or more available priorities for performing the observation or …
* Identity: [v2-0169](ValueSet-v2-0169.md)
  * Name: hl7VS-reportingPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the available priorities reporting the test results when the user i…
* Identity: [v2-0170](ValueSet-v2-0170.md)
  * Name: hl7VS-derivedSpecimen
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the parents and children for diagnostic studies, especially in micr…
* Identity: [v2-0173](ValueSet-v2-0173.md)
  * Name: hl7VS-coordinationOfBenefits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether this insurance works in conjunction with other insurance pl…
* Identity: [v2-0174](ValueSet-v2-0174.md)
  * Name: hl7VS-natureOfServiceTestObservation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying an identification of a test battery, an entire functional procedure or study, a…
* Identity: [v2-0175](ValueSet-v2-0175.md)
  * Name: hl7VS-masterFileIdentifierCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which are represented by codes identifying HL7Versions 2.x Master Files.
* Identity: [v2-0177](ValueSet-v2-0177.md)
  * Name: hl7VS-confidentialityCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the degree to which special confidentiality protection should be ap…
* Identity: [v2-0178](ValueSet-v2-0178.md)
  * Name: hl7VS-file-levelEventCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI…
* Identity: [v2-0179](ValueSet-v2-0179.md)
  * Name: hl7VS-responseLevel
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying application response levels defined for a given Master File Message at the MFE …
* Identity: [v2-0180](ValueSet-v2-0180.md)
  * Name: hl7VS-masterfileActionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying an action for a master file record. Used in HL7 V2.x messaging in the MFE segm…
* Identity: [v2-0181](ValueSet-v2-0181.md)
  * Name: hl7VS-mfnRecode-levelErrorReturn
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts which code status values for requested master file record update operations.
* Identity: [v2-0183](ValueSet-v2-0183.md)
  * Name: hl7VS-active-inactive
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether a person is currently a valid staff member.
* Identity: [v2-0185](ValueSet-v2-0185.md)
  * Name: hl7VS-preferredMethodOfContrct
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify which of a group of multiple phone numbers is the preferred method …
* Identity: [v2-0187](ValueSet-v2-0187.md)
  * Name: hl7VS-providerBilling
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify how provider services are billed.
* Identity: [v2-0189](ValueSet-v2-0189.md)
  * Name: hl7VS-ethnicGroup
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts further defining a patient's ancestry. In the US, a current use is to use these codes to …
* Identity: [v2-0190](ValueSet-v2-0190.md)
  * Name: hl7VS-addressType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying types or kinds of addresses.
* Identity: [v2-0191](ValueSet-v2-0191.md)
  * Name: hl7VS-typeOfData
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts declaring the general type of media data that is encoded.
* Identity: [v2-0193](ValueSet-v2-0193.md)
  * Name: hl7VS-amountClass
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the amount quantity class.
* Identity: [v2-0200](ValueSet-v2-0200.md)
  * Name: hl7VS-nameType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts for types of names for persons.
* Identity: [v2-0201](ValueSet-v2-0201.md)
  * Name: hl7VS-telecommunicationUseCode
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts for specifying a specific use of a telecommunication number.
* Identity: [v2-0202](ValueSet-v2-0202.md)
  * Name: hl7VS-telecommunicationEquipmentType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts for specifying a type of telecommunication equipment.
* Identity: [v2-0203](ValueSet-v2-0203.md)
  * Name: hl7VS-identifierType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying types of identififiers, as used in person and organization identification datat…
* Identity: [v2-0204](ValueSet-v2-0204.md)
  * Name: hl7VS-organizationalNameType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts used to specify the type of name for an organization i.e., legal name, display name.
* Identity: [v2-0205](ValueSet-v2-0205.md)
  * Name: hl7VS-priceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the intent for the dollar amount on a pricing transaction.
* Identity: [v2-0206](ValueSet-v2-0206.md)
  * Name: hl7VS-segmentActionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating…
* Identity: [v2-0207](ValueSet-v2-0207.md)
  * Name: hl7VS-processingMode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that indicate an archival process or an initial load process.
* Identity: [v2-0208](ValueSet-v2-0208.md)
  * Name: hl7VS-queryResponseStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts defining precise response status concepts in support of HL7 Version 2 query messaging.
* Identity: [v2-0209](ValueSet-v2-0209.md)
  * Name: hl7VS-relationalOperator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the relationship between HL7 segment field names identified in a que…
* Identity: [v2-0210](ValueSet-v2-0210.md)
  * Name: hl7VS-relationalConjunction
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used with relational operator values to group more than one segment field name.
* Identity: [v2-0211](ValueSet-v2-0211.md)
  * Name: hl7VS-alternateCharacterSets
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify one of a number of possible standard alternate character sets for …
* Identity: [v2-0213](ValueSet-v2-0213.md)
  * Name: hl7VS-purgeStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the state of a visit relative to its place in a purge workflow.
* Identity: [v2-0214](ValueSet-v2-0214.md)
  * Name: hl7VS-specialProgramCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that record a health insurance program required for healthcare visit reimburseme…
* Identity: [v2-0215](ValueSet-v2-0215.md)
  * Name: hl7VS-publicityCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying a level of publicity of information about a patient for a specific visit.
* Identity: [v2-0216](ValueSet-v2-0216.md)
  * Name: hl7VS-patientStatusCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the state of a care episode for a patient.
* Identity: [v2-0217](ValueSet-v2-0217.md)
  * Name: hl7VS-visitPriorityCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define a relative level of urgency applied to a patient visit.
* Identity: [v2-0220](ValueSet-v2-0220.md)
  * Name: hl7VS-livingArrangement
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts characterizing the situation that patient-associated parties live in at their residential …
* Identity: [v2-0223](ValueSet-v2-0223.md)
  * Name: hl7VS-livingDependency
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-…
* Identity: [v2-0224](ValueSet-v2-0224.md)
  * Name: hl7VS-transportArranged
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes defining whether patient transportation preparations are in place.
* Identity: [v2-0225](ValueSet-v2-0225.md)
  * Name: hl7VS-escortRequired
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes indicating whether a patient must be accompanied while travelling to a diagnosti…
* Identity: [v2-0227](ValueSet-v2-0227.md)
  * Name: PHVS_ManufacturersOfVaccinesMVX_CDC_NIP
  * Version: 4.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-06-12
  * Description: Value Set of codes that specify the organization that manufactures a vaccine. The values are mainta…
* Identity: [v2-0228](ValueSet-v2-0228.md)
  * Name: hl7VS-diagnosisClassification
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that classify whether a patient visit can be related to a diagnosis.
* Identity: [v2-0230](ValueSet-v2-0230.md)
  * Name: hl7VS-procedureFunctionalType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that classify a procedure.
* Identity: [v2-0231](ValueSet-v2-0231.md)
  * Name: hl7VS-studentStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that designate whether a guarantor is a full or part time student.
* Identity: [v2-0232](ValueSet-v2-0232.md)
  * Name: hl7VS-insuranceCompanyContactReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe why an insurance company has been contacted.
* Identity: [v2-0234](ValueSet-v2-0234.md)
  * Name: hl7VS-reportTiming
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the time span of a report or the reason for a report sent to a reg…
* Identity: [v2-0235](ValueSet-v2-0235.md)
  * Name: hl7VS-reportSource
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify where a report sender learned about an event.
* Identity: [v2-0236](ValueSet-v2-0236.md)
  * Name: hl7VS-eventReportedTo
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the type of entity to which the event has been reported.
* Identity: [v2-0237](ValueSet-v2-0237.md)
  * Name: hl7VS-eventQualification
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that qualify an event related to a product experience.
* Identity: [v2-0238](ValueSet-v2-0238.md)
  * Name: hl7VS-eventSeriousness
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that a sender to designate an event as serious or significant.
* Identity: [v2-0239](ValueSet-v2-0239.md)
  * Name: hl7VS-eventExpected
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that communicate whether an event has been judged to be expected or unexpected.
* Identity: [v2-0240](ValueSet-v2-0240.md)
  * Name: hl7VS-eventConsequence
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the impact of an event on a patient.
* Identity: [v2-0241](ValueSet-v2-0241.md)
  * Name: hl7VS-patientOutcome
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the overall state of a patient as a result of patient care.
* Identity: [v2-0242](ValueSet-v2-0242.md)
  * Name: hl7VS-primaryObserver'sQualification
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that provide a general description of the kind of health care professional who p…
* Identity: [v2-0243](ValueSet-v2-0243.md)
  * Name: hl7VS-identityMayBeDivulged
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define whether the primary observer has given permission for their identifi…
* Identity: [v2-0247](ValueSet-v2-0247.md)
  * Name: hl7VS-startOfEvaluation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describes the status of product evaluation.
* Identity: [v2-0248](ValueSet-v2-0248.md)
  * Name: hl7VS-productSource
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the evaluation state of a product identified in an incident.
* Identity: [v2-0250](ValueSet-v2-0250.md)
  * Name: hl7VS-relatednessAssessment
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that provide an estimate of whether an issue with a product was the cause of an…
* Identity: [v2-0251](ValueSet-v2-0251.md)
  * Name: hl7VS-actionTakenInResponseToTheEvent
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the action taken as a result of an event related to a product issue.
* Identity: [v2-0252](ValueSet-v2-0252.md)
  * Name: hl7VS-causalityObservations
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that record event observations regarding what may have caused a product related …
* Identity: [v2-0253](ValueSet-v2-0253.md)
  * Name: hl7VS-indirectExposureMechanism
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the mechanism of product transmission when the product has not bee…
* Identity: [v2-0254](ValueSet-v2-0254.md)
  * Name: hl7VS-kindOfQuantity
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the underlying kind of property represented by an observation. Th…
* Identity: [v2-0255](ValueSet-v2-0255.md)
  * Name: hl7VS-durationCategories
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that classify an observation definition as intended to measure a patient's state…
* Identity: [v2-0256](ValueSet-v2-0256.md)
  * Name: hl7VS-timeDelayPostChallenge
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that classify an observation definition as being a component of a challenge test.
* Identity: [v2-0257](ValueSet-v2-0257.md)
  * Name: hl7VS-natureOfChallenge
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that further describe an observation definition that is characterized as a chall…
* Identity: [v2-0258](ValueSet-v2-0258.md)
  * Name: hl7VS-relationshipModifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that an observation definition to describe the subject of an observation in rela…
* Identity: [v2-0260](ValueSet-v2-0260.md)
  * Name: hl7VS-patientLocationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the kind of location described in the location definition.
* Identity: [v2-0261](ValueSet-v2-0261.md)
  * Name: hl7VS-locationEquipment
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the equipment available in a location definition identified as a r…
* Identity: [v2-0262](ValueSet-v2-0262.md)
  * Name: hl7VS-privacyLevel
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the level of privacy a patient will be afforded when assigned to t…
* Identity: [v2-0263](ValueSet-v2-0263.md)
  * Name: hl7VS-levelOfCare
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the level of care a patient may be afforded when assigned to this …
* Identity: [v2-0265](ValueSet-v2-0265.md)
  * Name: hl7VS-specialtyType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the specialty of the care professional who is supported when using…
* Identity: [v2-0267](ValueSet-v2-0267.md)
  * Name: hl7VS-daysOfTheWeek
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the day(s) of the week when a location may be scheduled for appoin…
* Identity: [v2-0268](ValueSet-v2-0268.md)
  * Name: hl7VS-override
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define whether a Charge Description Master description may be overridden or…
* Identity: [v2-0269](ValueSet-v2-0269.md)
  * Name: hl7VS-chargeOnIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the event upon which a charge should be generated.
* Identity: [v2-0270](ValueSet-v2-0270.md)
  * Name: hl7VS-reportTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the kind of patient document.
* Identity: [v2-0271](ValueSet-v2-0271.md)
  * Name: hl7VS-documentCompletionStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that record the state of a document in a workflow.
* Identity: [v2-0272](ValueSet-v2-0272.md)
  * Name: hl7VS-documentConfidentialityStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the degree to which special confidentiality protection should be ap…
* Identity: [v2-0273](ValueSet-v2-0273.md)
  * Name: hl7VS-documentAvailabilityStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define whether a patient document is appropriate or available for use in pa…
* Identity: [v2-0275](ValueSet-v2-0275.md)
  * Name: hl7VS-documentStorageStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the availability of a document in relation to the type of storage.
* Identity: [v2-0276](ValueSet-v2-0276.md)
  * Name: hl7VS-appointmentReasonCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the kind of appointment or the reason why an appointment has been …
* Identity: [v2-0277](ValueSet-v2-0277.md)
  * Name: hl7VS-appointmentTypeCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that an appointment request to describe the kind of appointment.
* Identity: [v2-0278](ValueSet-v2-0278.md)
  * Name: hl7VS-fillerStatusCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe an appointment status from the perspective of the entity assigned …
* Identity: [v2-0279](ValueSet-v2-0279.md)
  * Name: hl7VS-allowSubstitutionCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that indicate whether the appointment resource may be substituted for another by…
* Identity: [v2-0280](ValueSet-v2-0280.md)
  * Name: hl7VS-referralPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that designate the urgency of a referral.
* Identity: [v2-0281](ValueSet-v2-0281.md)
  * Name: hl7VS-referralType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the general category of healthcare professional desired to satisfy…
* Identity: [v2-0282](ValueSet-v2-0282.md)
  * Name: hl7VS-referralDisposition
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the expected response from the healthcare professional receiving a…
* Identity: [v2-0283](ValueSet-v2-0283.md)
  * Name: hl7VS-referralStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the state of a referral.
* Identity: [v2-0284](ValueSet-v2-0284.md)
  * Name: hl7VS-referralCategory
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe the patient care setting where a referral should take place.
* Identity: [v2-0286](ValueSet-v2-0286.md)
  * Name: hl7VS-providerRole
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that define the relationship between a referral recipient and a patient or betwe…
* Identity: [v2-0287](ValueSet-v2-0287.md)
  * Name: hl7VS-actionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts used in Patient Care for the intent of a problem or goal. Used in Version 2 messaging in …
* Identity: [v2-0290](ValueSet-v2-0290.md)
  * Name: hl7VS-mimeBase64EncodingCharacters
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that are used for base64 MIME encoding. Base64 is defined as follows (adapted f…
* Identity: [v2-0292](ValueSet-v2-0292.md)
  * Name: PHVS_VaccinesAdministeredCVX_CDC_NIP
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the administered vaccines. The values are maintained by the US Ce…
* Identity: [v2-0294](ValueSet-v2-0294.md)
  * Name: hl7VS-timeSelectionCriteriaParameterClassCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe acceptable start and end times, as well as days of the week, for a…
* Identity: [v2-0298](ValueSet-v2-0298.md)
  * Name: hl7VS-rangeType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether a composite price range is experssed as a flat rate or a pe…
* Identity: [v2-0299](ValueSet-v2-0299.md)
  * Name: hl7VS-encoding
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concept identifying the type of IETF encoding used to represent successive octets of binary data as…
* Identity: [v2-0301](ValueSet-v2-0301.md)
  * Name: hl7VS-universalIdType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Types of UID (Universal Identifiers).
* Identity: [v2-0305](ValueSet-v2-0305.md)
  * Name: hl7VS-personLocationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the categorization of the person's location.
* Identity: [v2-0309](ValueSet-v2-0309.md)
  * Name: hl7VS-coverageType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Note that this set of codes is used generally in the US only.
* Identity: [v2-0311](ValueSet-v2-0311.md)
  * Name: hl7VS-jobStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a next of kin/associated party's job status.
* Identity: [v2-0315](ValueSet-v2-0315.md)
  * Name: hl7VS-livingWill
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether or not the patient has a living will and, if so, whether a …
* Identity: [v2-0316](ValueSet-v2-0316.md)
  * Name: hl7VS-organDonor
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the patient wants to donate his/her organs and whether an o…
* Identity: [v2-0317](ValueSet-v2-0317.md)
  * Name: hl7VS-annotations
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the coded entry associated with a given point in time during the wa…
* Identity: [v2-0321](ValueSet-v2-0321.md)
  * Name: hl7VS-dispenseMethod
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the method by which treatment is dispensed.
* Identity: [v2-0322](ValueSet-v2-0322.md)
  * Name: hl7VS-completionStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Status codes used in the workflow of treatment administration events.
* Identity: [v2-0323](ValueSet-v2-0323.md)
  * Name: hl7VS-actionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Status codes of record operations.
* Identity: [v2-0324](ValueSet-v2-0324.md)
  * Name: hl7VS-locationCharacteristicId
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an identifier code to show which characteristic is being communicat…
* Identity: [v2-0325](ValueSet-v2-0325.md)
  * Name: hl7VS-locationRelationshipId
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an identifier code to show which relationship is being communicated…
* Identity: [v2-0326](ValueSet-v2-0326.md)
  * Name: hl7VS-visitIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the level on which data are being sent. It is the indicator used t…
* Identity: [v2-0329](ValueSet-v2-0329.md)
  * Name: hl7VS-quantityMethod
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the method by which the quantity distributed is measured.
* Identity: [v2-0330](ValueSet-v2-0330.md)
  * Name: hl7VS-marketingBasis
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the basis for marketing approval.
* Identity: [v2-0331](ValueSet-v2-0331.md)
  * Name: hl7VS-facilityType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of facility.
* Identity: [v2-0332](ValueSet-v2-0332.md)
  * Name: hl7VS-networkSourceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that indicate (in certain systems) whether a lower level source identifier is an…
* Identity: [v2-0334](ValueSet-v2-0334.md)
  * Name: hl7VS-disabledPerson
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify to which person the disability information relates in the message. …
* Identity: [v2-0335](ValueSet-v2-0335.md)
  * Name: hl7VS-repeatPattern
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the interval between repeated services. See the Comment/Usage Note …
* Identity: [v2-0336](ValueSet-v2-0336.md)
  * Name: hl7VS-referralReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason for which the referral will take place.
* Identity: [v2-0337](ValueSet-v2-0337.md)
  * Name: hl7VS-certificationStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the practitioner's speciality certification.
* Identity: [v2-0338](ValueSet-v2-0338.md)
  * Name: hl7VS-practitionerIdNumberType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of number used for the practitioner identification.
* Identity: [v2-0339](ValueSet-v2-0339.md)
  * Name: hl7VS-advancedBeneficiaryNoticeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Status codes specifying a patient's or a patient's representative's consent for responsibility to p…
* Identity: [v2-0344](ValueSet-v2-0344.md)
  * Name: hl7VS-patient’sRelationshipToInsured
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the relationship of the patient to the insured, as defined by CMS o…
* Identity: [v2-0350](ValueSet-v2-0350.md)
  * Name: hl7VS-occurrenceCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts drawn from the National Uniform Billing Committee (NUBC) code for the event or occurrence …
* Identity: [v2-0351](ValueSet-v2-0351.md)
  * Name: hl7VS-occurrenceSpan
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts drawn from the National Uniform Billing Committee (NUBC) code that identifies an event tha…
* Identity: [v2-0353](ValueSet-v2-0353.md)
  * Name: hl7VS-cweStatuses
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that represent an exception identifier code; that is, a code that is not defined in the va…
* Identity: [v2-0354](ValueSet-v2-0354.md)
  * Name: hl7VS-messageStructure
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7 abstract message structure codes.
* Identity: [v2-0355](ValueSet-v2-0355.md)
  * Name: hl7VS-primaryKeyValueType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type for the master file record identifier.
* Identity: [v2-0356](ValueSet-v2-0356.md)
  * Name: hl7VS-alternateCharacterSetHandlingScheme
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that specify the scheme used when any alternative character sets are specified in the seco…
* Identity: [v2-0357](ValueSet-v2-0357.md)
  * Name: hl7VS-messageErrorConditionCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7 (communications) error codes, as transmitted in a message acknowledgement.
* Identity: [v2-0359](ValueSet-v2-0359.md)
  * Name: hl7VS-diagnosisPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that identify the significance or priority of the diagnosis code. Note that the codes are…
* Identity: [v2-0360](ValueSet-v2-0360.md)
  * Name: hl7VS-degreeLicenseCertificate
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifi…
* Identity: [v2-0364](ValueSet-v2-0364.md)
  * Name: hl7VS-commentType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the type of comment text being sent in the specific comment record.
* Identity: [v2-0365](ValueSet-v2-0365.md)
  * Name: hl7VS-equipmentState
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the status the equipment was in at the time the transaction was in…
* Identity: [v2-0366](ValueSet-v2-0366.md)
  * Name: hl7VS-local-remoteControlState
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the current state of control associated with the equipment. Equi…
* Identity: [v2-0367](ValueSet-v2-0367.md)
  * Name: hl7VS-alertLevel
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the highest level of the alert state (e.g.,highest alert severity)…
* Identity: [v2-0368](ValueSet-v2-0368.md)
  * Name: hl7VS-remoteControlCommand
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the comment the component is to initiate.
* Identity: [v2-0369](ValueSet-v2-0369.md)
  * Name: hl7VS-specimenRole
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the role of a sample.
* Identity: [v2-0370](ValueSet-v2-0370.md)
  * Name: hl7VS-containerStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the status of the unique container in which the specimen resides a…
* Identity: [v2-0371](ValueSet-v2-0371.md)
  * Name: hl7VS-additivePreservative
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts specifying any additive introduced to the specimen before or at the time of collection. T…
* Identity: [v2-0372](ValueSet-v2-0372.md)
  * Name: hl7VS-specimenComponent
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the specimen component, e.g., supernatant, sediment, etc.
* Identity: [v2-0373](ValueSet-v2-0373.md)
  * Name: hl7VS-treatment
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the specimen treatment performed during lab processing.
* Identity: [v2-0374](ValueSet-v2-0374.md)
  * Name: hl7VS-systemInducedContaminants
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the specimen contaminant identifier associated with the specimen i…
* Identity: [v2-0375](ValueSet-v2-0375.md)
  * Name: hl7VS-artificialBlood
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the artificial blood identifier associated with the specimen.
* Identity: [v2-0376](ValueSet-v2-0376.md)
  * Name: hl7VS-specialHandlingConsiderations
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts describing how a specimen and/or container needs to be handled from the time of collection…
* Identity: [v2-0377](ValueSet-v2-0377.md)
  * Name: hl7VS-otherEnvironmentalFactors
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify the other environmental factors associated with the specimen in a …
* Identity: [v2-0383](ValueSet-v2-0383.md)
  * Name: hl7VS-substanceStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the status of the inventoried item. The status indicates the curren…
* Identity: [v2-0384](ValueSet-v2-0384.md)
  * Name: hl7VS-substanceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the type of substance.
* Identity: [v2-0387](ValueSet-v2-0387.md)
  * Name: hl7VS-commandResponse
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the response of the previously issued command.
* Identity: [v2-0388](ValueSet-v2-0388.md)
  * Name: hl7VS-processingType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the processing type that applies to the test code. If this attribut…
* Identity: [v2-0389](ValueSet-v2-0389.md)
  * Name: hl7VS-analyteRepeatStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the repeat status for the analyte/result (e.g. original, rerun, repe…
* Identity: [v2-0391](ValueSet-v2-0391.md)
  * Name: hl7VS-segmentGroup
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the optional segment groups which are to be included in a response.
* Identity: [v2-0392](ValueSet-v2-0392.md)
  * Name: hl7VS-matchReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying what search components (e.g., name, birthdate, social security numbe…
* Identity: [v2-0393](ValueSet-v2-0393.md)
  * Name: hl7VS-matchAlgorithms
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the name or identity of the specific search algorithm to which the R…
* Identity: [v2-0394](ValueSet-v2-0394.md)
  * Name: hl7VS-responseModality
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying the timing and grouping of the response message(s).
* Identity: [v2-0395](ValueSet-v2-0395.md)
  * Name: hl7VS-modifyIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying whether the subscription is new or is being modified.
* Identity: [v2-0396](ValueSet-v2-0396.md)
  * Name: hl7VS-codingSystem
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Names of coding systems. Each coding system is assigned a unique identifier, which is generally a s…
* Identity: [v2-0397](ValueSet-v2-0397.md)
  * Name: hl7VS-sequencing
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying how the field or parameter will be sorted and, if sorted, whether th…
* Identity: [v2-0398](ValueSet-v2-0398.md)
  * Name: hl7VS-continuationStyleCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes identifying whether it is a fragmented message or part of an interactive continu…
* Identity: [v2-0401](ValueSet-v2-0401.md)
  * Name: hl7VS-governmentReimbursementProgram
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify codes that indicate an agency that the practitioner is authorized t…
* Identity: [v2-0402](ValueSet-v2-0402.md)
  * Name: hl7VS-schoolType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a categorization of an academic institution that grants a degree to…
* Identity: [v2-0403](ValueSet-v2-0403.md)
  * Name: hl7VS-languageAbility
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify codes that indicate the ability that a Staff Member possesses with …
* Identity: [v2-0404](ValueSet-v2-0404.md)
  * Name: hl7VS-languageProficiency
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes which specify the level of knowledge a person possesses with respect to a langua…
* Identity: [v2-0406](ValueSet-v2-0406.md)
  * Name: hl7VS-organizationUnitType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the environment in which the provider acts in the role associated w…
* Identity: [v2-0409](ValueSet-v2-0409.md)
  * Name: hl7VS-applicationChangeType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a type of change being requested (if NMR query) or announced (if NM…
* Identity: [v2-0415](ValueSet-v2-0415.md)
  * Name: hl7VS-drgTransferType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a type of hospital receiving a transfer patient, which affects how …
* Identity: [v2-0416](ValueSet-v2-0416.md)
  * Name: hl7VS-procedureDrgType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a procedure's priority ranking relative to its DRG.
* Identity: [v2-0417](ValueSet-v2-0417.md)
  * Name: hl7VS-tissueTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of tissue removed from a patient during a procedure.
* Identity: [v2-0418](ValueSet-v2-0418.md)
  * Name: hl7VS-procedurePriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a number that identifies the significance or priority of the procedur…
* Identity: [v2-0421](ValueSet-v2-0421.md)
  * Name: hl7VS-severityOfIllnessCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the severity ranking of a patient's illness.
* Identity: [v2-0422](ValueSet-v2-0422.md)
  * Name: hl7VS-triageCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a patient's prioritization within the context of this abstract.
* Identity: [v2-0423](ValueSet-v2-0423.md)
  * Name: hl7VS-caseCategoryCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the reason a non-urgent patient presents to the emergency room for tr…
* Identity: [v2-0424](ValueSet-v2-0424.md)
  * Name: hl7VS-gestationCategoryCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the status of the birth in relation to the gestation
* Identity: [v2-0425](ValueSet-v2-0425.md)
  * Name: hl7VS-newbornCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying whether the baby was born in or out of the facility.
* Identity: [v2-0426](ValueSet-v2-0426.md)
  * Name: hl7VS-bloodProductCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the blood product code.
* Identity: [v2-0427](ValueSet-v2-0427.md)
  * Name: hl7VS-riskManagementIncidentCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the incident that occurred during a patient's stay.
* Identity: [v2-0428](ValueSet-v2-0428.md)
  * Name: hl7VS-incidentTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a classification of the incident type.
* Identity: [v2-0429](ValueSet-v2-0429.md)
  * Name: hl7VS-productionClassCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the code and/or text indicating the primary use for which the living …
* Identity: [v2-0430](ValueSet-v2-0430.md)
  * Name: hl7VS-modeOfArrivalCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying how the patient was brought to the healthcare facility.
* Identity: [v2-0431](ValueSet-v2-0431.md)
  * Name: hl7VS-recreationalDrugUseCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying what recreational drugs the patient uses.
* Identity: [v2-0432](ValueSet-v2-0432.md)
  * Name: hl7VS-admissionLevelOfCareCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the acuity level assigned to the patient at the time of admission.
* Identity: [v2-0433](ValueSet-v2-0433.md)
  * Name: hl7VS-precautionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying non-clincal precautions that need to be taken with the patient.
* Identity: [v2-0434](ValueSet-v2-0434.md)
  * Name: hl7VS-patientConditionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the patient's current medical condition for the purpose of communicat…
* Identity: [v2-0435](ValueSet-v2-0435.md)
  * Name: hl7VS-advanceDirectiveCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the patient's instructions to the healthcare facility.
* Identity: [v2-0436](ValueSet-v2-0436.md)
  * Name: hl7VS-sensitivityToCausativeAgentCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the reason the patient should not be exposed to a substance.
* Identity: [v2-0437](ValueSet-v2-0437.md)
  * Name: hl7VS-alertDeviceCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying any type of allergy alert device the patient may be carrying or weari…
* Identity: [v2-0438](ValueSet-v2-0438.md)
  * Name: hl7VS-allergyClinicalStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the verification status for the allergy.
* Identity: [v2-0440](ValueSet-v2-0440.md)
  * Name: hl7VS-dataTypes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the data type.
* Identity: [v2-0441](ValueSet-v2-0441.md)
  * Name: hl7VS-immunizationRegistryStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Immunization registry status codes of a patient. Used in Version 2 messaging in the PD1 segment.
* Identity: [v2-0442](ValueSet-v2-0442.md)
  * Name: hl7VS-locationServiceCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the types of services provided by the location.
* Identity: [v2-0443](ValueSet-v2-0443.md)
  * Name: hl7VS-providerRole
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the functional involvement with the activity being transmitted (e.g…
* Identity: [v2-0444](ValueSet-v2-0444.md)
  * Name: hl7VS-nameAssemblyOrder
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the preferred display order of the components of this person name.
* Identity: [v2-0445](ValueSet-v2-0445.md)
  * Name: hl7VS-identityReliabilityCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reliability of patient/person identifying data transmitted via …
* Identity: [v2-0450](ValueSet-v2-0450.md)
  * Name: hl7VS-eventType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the type of event of the message.
* Identity: [v2-0456](ValueSet-v2-0456.md)
  * Name: hl7VS-revenueCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a revenue code as specified in the National Uniform Billing Committee…
* Identity: [v2-0457](ValueSet-v2-0457.md)
  * Name: hl7VS-overallClaimDispositionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the final status of the claim.
* Identity: [v2-0465](ValueSet-v2-0465.md)
  * Name: hl7VS-name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an indication of the representation provided by the data item.
* Identity: [v2-0466](ValueSet-v2-0466.md)
  * Name: hl7VS-ambulatoryPaymentClassificationCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the derived Ambulatory Payment Classification (APC) code.
* Identity: [v2-0468](ValueSet-v2-0468.md)
  * Name: hl7VS-paymentAdjustmentCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify any payment adjustment due to drugs or medical devices.
* Identity: [v2-0469](ValueSet-v2-0469.md)
  * Name: hl7VS-packagingStatusCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the packaging status of the service.
* Identity: [v2-0470](ValueSet-v2-0470.md)
  * Name: hl7VS-reimbursementTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the fee schedule reimbursement type applied to a line item.
* Identity: [v2-0472](ValueSet-v2-0472.md)
  * Name: hl7VS-tqConjunctionId
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify that a second timing specification is to follow using the repeat de…
* Identity: [v2-0473](ValueSet-v2-0473.md)
  * Name: hl7VS-formularyStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether or not the service (pharmaceutical) is in the formulary.
* Identity: [v2-0474](ValueSet-v2-0474.md)
  * Name: hl7VS-organizationUnitType-Org
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the classification of the organization unit.
* Identity: [v2-0475](ValueSet-v2-0475.md)
  * Name: hl7VS-chargeTypeReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the choice of, and providing the clinical rationale for, a selected…
* Identity: [v2-0477](ValueSet-v2-0477.md)
  * Name: hl7VS-controlledSubstanceSchedule
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the class of the drug or other substance if its usage is controlled…
* Identity: [v2-0478](ValueSet-v2-0478.md)
  * Name: hl7VS-formularyStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether or not the pharmaceutical substance is part of the local fo…
* Identity: [v2-0480](ValueSet-v2-0480.md)
  * Name: hl7VS-pharmacyOrderTypes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the general category of pharmacy order which may be used to determi…
* Identity: [v2-0482](ValueSet-v2-0482.md)
  * Name: hl7VS-orderType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the order is to be executed in an inpatient setting or an o…
* Identity: [v2-0483](ValueSet-v2-0483.md)
  * Name: hl7VS-authorizationMode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts of forms of authorization a recorder may receive from the responsible practitioner to crea…
* Identity: [v2-0484](ValueSet-v2-0484.md)
  * Name: hl7VS-dispenseType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of dispensing event that occurred.
* Identity: [v2-0485](ValueSet-v2-0485.md)
  * Name: hl7VS-extendedPriorityCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts describing the urgency of a request carried in an order. Used in Version 2 messaging in t…
* Identity: [v2-0487](ValueSet-v2-0487.md)
  * Name: hl7VS-specimenType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that describe the precise nature of an entity that may be used as the source material for …
* Identity: [v2-0488](ValueSet-v2-0488.md)
  * Name: hl7VS-specimenCollectionMethod
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts to document procedures or processes by which a specimen may be collected. This is one of …
* Identity: [v2-0489](ValueSet-v2-0489.md)
  * Name: hl7VS-riskCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify any known or suspected specimen hazards, e.g., exceptionally infect…
* Identity: [v2-0490](ValueSet-v2-0490.md)
  * Name: hl7VS-specimenRejectReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Reasons a specimen may be rejected for a specified observation/result/analysis. Used in Version 2 …
* Identity: [v2-0491](ValueSet-v2-0491.md)
  * Name: hl7VS-specimenQuality
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the degree or grade of excellence of the specimen at receipt.
* Identity: [v2-0492](ValueSet-v2-0492.md)
  * Name: hl7VS-specimenAppropriateness
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the suitability of the specimen for the particular planned use as d…
* Identity: [v2-0493](ValueSet-v2-0493.md)
  * Name: hl7VS-specimenCondition
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts of modes or states of being that describe the nature of a specimen. Used in Version 2 mes…
* Identity: [v2-0494](ValueSet-v2-0494.md)
  * Name: hl7VS-specimenChildRole
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify for child specimens the relationship between this specimen and the …
* Identity: [v2-0495](ValueSet-v2-0495.md)
  * Name: hl7VS-bodySiteModifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the modifier for the body site.
* Identity: [v2-0496](ValueSet-v2-0496.md)
  * Name: hl7VS-consentType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify to what the subject is consenting, i.e. what type of service, surgi…
* Identity: [v2-0497](ValueSet-v2-0497.md)
  * Name: hl7VS-consentMode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the method in which a subject provides consent.
* Identity: [v2-0498](ValueSet-v2-0498.md)
  * Name: hl7VS-consentStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the consent has been sought and granted.
* Identity: [v2-0499](ValueSet-v2-0499.md)
  * Name: hl7VS-consentBypassReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason the subject's consent was not sought.
* Identity: [v2-0500](ValueSet-v2-0500.md)
  * Name: hl7VS-consentDisclosureLevel
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify how much information was disclosed to the subject as part of the in…
* Identity: [v2-0501](ValueSet-v2-0501.md)
  * Name: hl7VS-consentNon-disclosureReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a reason the subject did not receive full disclosure.
* Identity: [v2-0502](ValueSet-v2-0502.md)
  * Name: hl7VS-non-subjectConsenterReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a reason consent was granted by a person other than the subject of …
* Identity: [v2-0503](ValueSet-v2-0503.md)
  * Name: hl7VS-sequenceResultsFlag
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the sequencing relationship between the current service request and…
* Identity: [v2-0504](ValueSet-v2-0504.md)
  * Name: hl7VS-sequenceConditionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the relationship between the start/end of the related service reque…
* Identity: [v2-0505](ValueSet-v2-0505.md)
  * Name: hl7VS-cyclicEntryExitIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify if this service request is the first or last service request in a c…
* Identity: [v2-0506](ValueSet-v2-0506.md)
  * Name: hl7VS-serviceRequestRelationship
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an additional or alternate relationship between this service reques…
* Identity: [v2-0507](ValueSet-v2-0507.md)
  * Name: hl7VS-observationResultHandling
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts regarding the handling of a result.
* Identity: [v2-0508](ValueSet-v2-0508.md)
  * Name: hl7VS-bloodProductProcessingRequirements
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify additional information about the blood component class associated w…
* Identity: [v2-0510](ValueSet-v2-0510.md)
  * Name: hl7VS-bloodProductDispenseStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the current status of the specified blood product as indicated by t…
* Identity: [v2-0511](ValueSet-v2-0511.md)
  * Name: hl7VS-bpObservationStatusCodesInterpretation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the interpretation for the blood product observation status codes. …
* Identity: [v2-0513](ValueSet-v2-0513.md)
  * Name: hl7VS-bloodProductTransfusion-dispositionStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the current status of the specified blood product as indicated by t…
* Identity: [v2-0514](ValueSet-v2-0514.md)
  * Name: hl7VS-transfusionAdverseReaction
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of adverse reaction that the recipient of the blood produc…
* Identity: [v2-0516](ValueSet-v2-0516.md)
  * Name: hl7VS-errorSeverity
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts documenting the severity of an application error as reported during acknowledgment of mess…
* Identity: [v2-0517](ValueSet-v2-0517.md)
  * Name: hl7VS-informPersonCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify who (if anyone) shouldor should not be informed of an error.
* Identity: [v2-0518](ValueSet-v2-0518.md)
  * Name: hl7VS-overrideType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify what type of override can be used to override the specific error id…
* Identity: [v2-0520](ValueSet-v2-0520.md)
  * Name: hl7VS-messageWaitingPriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify how important the most important waiting mesasge is. For example, …
* Identity: [v2-0523](ValueSet-v2-0523.md)
  * Name: hl7VS-computationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify if the change is computed as a percent change or as an absolute cha…
* Identity: [v2-0524](ValueSet-v2-0524.md)
  * Name: hl7VS-sequenceCondition
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identify whether sequence conditions or a repeating cycle of orders is defi…
* Identity: [v2-0527](ValueSet-v2-0527.md)
  * Name: hl7VS-calendarAlignment
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an alignment of the repetition to a calendar (e.g., to distinguish …
* Identity: [v2-0528](ValueSet-v2-0528.md)
  * Name: hl7VS-eventRelatedPeriod
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a common (periodical) activity of daily living.
* Identity: [v2-0529](ValueSet-v2-0529.md)
  * Name: hl7VS-precision
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the degree of precision of a time stamp.
* Identity: [v2-0530](ValueSet-v2-0530.md)
  * Name: hl7VS-organization-Agency-Department
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the agency or department that assigned a specified identifier.
* Identity: [v2-0532](ValueSet-v2-0532.md)
  * Name: hl7VS-expandedYes-NoIndicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an expansion on the original Yes/No indicator table by including "f…
* Identity: [v2-0534](ValueSet-v2-0534.md)
  * Name: hl7VS-notifyClergyCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the clergy should be notified.
* Identity: [v2-0535](ValueSet-v2-0535.md)
  * Name: hl7VS-signatureCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that indicate how a patient/subscriber authorization signature is obtained and how it is b…
* Identity: [v2-0536](ValueSet-v2-0536.md)
  * Name: hl7VS-certificateStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the certificate held by a health professional.
* Identity: [v2-0538](ValueSet-v2-0538.md)
  * Name: hl7VS-institutionRelationshipType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the relationship the staff person has with the institution for whom…
* Identity: [v2-0540](ValueSet-v2-0540.md)
  * Name: hl7VS-inactiveReasonCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason the staff member is inactive.
* Identity: [v2-0544](ValueSet-v2-0544.md)
  * Name: hl7VS-containerCondition
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify at each receipt the status of the container in which the specimen i…
* Identity: [v2-0547](ValueSet-v2-0547.md)
  * Name: hl7VS-jurisdictionalBreadth
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the breadth/extent of the jurisdiction where the qualification is v…
* Identity: [v2-0548](ValueSet-v2-0548.md)
  * Name: hl7VS-signatory'sRelationshipToSubject
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the relationship of the consenter to the subject.
* Identity: [v2-0550](ValueSet-v2-0550.md)
  * Name: hl7VS-bodyParts
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the part of the body.
* Identity: [v2-0553](ValueSet-v2-0553.md)
  * Name: hl7VS-invoiceControlCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify what invoice action is being performed by this message.
* Identity: [v2-0554](ValueSet-v2-0554.md)
  * Name: hl7VS-invoiceReasonCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason for an invoice.
* Identity: [v2-0555](ValueSet-v2-0555.md)
  * Name: hl7VS-invoiceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of invoice.
* Identity: [v2-0556](ValueSet-v2-0556.md)
  * Name: hl7VS-benefitGroup
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the benefit group.
* Identity: [v2-0557](ValueSet-v2-0557.md)
  * Name: hl7VS-payeeType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of payee (e.g., organization, person).
* Identity: [v2-0558](ValueSet-v2-0558.md)
  * Name: hl7VS-payeeRelationshipToInvoice
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the relationship to the invoice for Person Payee Types.
* Identity: [v2-0559](ValueSet-v2-0559.md)
  * Name: hl7VS-product-serviceStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the processing status for the Product/Service Code.
* Identity: [v2-0560](ValueSet-v2-0560.md)
  * Name: hl7VS-quantityUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the adjustment quantity.
* Identity: [v2-0561](ValueSet-v2-0561.md)
  * Name: hl7VS-product-servicesClarification
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the Product/Service Code.
* Identity: [v2-0562](ValueSet-v2-0562.md)
  * Name: hl7VS-processingConsiderationCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify special processing requested of Payer for this Product/Service Line…
* Identity: [v2-0564](ValueSet-v2-0564.md)
  * Name: hl7VS-adjustmentCategoryCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the category of adjustment and is used to assist in determining …
* Identity: [v2-0565](ValueSet-v2-0565.md)
  * Name: hl7VS-providerAdjustmentReasonCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the reason for this adjustment.
* Identity: [v2-0566](ValueSet-v2-0566.md)
  * Name: hl7VS-bloodUnitType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the type of blood unit
* Identity: [v2-0567](ValueSet-v2-0567.md)
  * Name: hl7VS-weightUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes of units of measure that are used to specify weight.
* Identity: [v2-0568](ValueSet-v2-0568.md)
  * Name: hl7VS-volumeUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes of units of measure that are used to specify volume.
* Identity: [v2-0569](ValueSet-v2-0569.md)
  * Name: hl7VS-adjustmentAction
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the action requested of a party that receives an adjustment.
* Identity: [v2-0570](ValueSet-v2-0570.md)
  * Name: hl7VS-paymentMethodCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the method for the movement of payment.
* Identity: [v2-0571](ValueSet-v2-0571.md)
  * Name: hl7VS-invoiceProcessingResultsStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the processing status for an Invoice Processing Result.
* Identity: [v2-0572](ValueSet-v2-0572.md)
  * Name: hl7VS-taxStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes used to specify the tax status of a provider.
* Identity: [v2-0615](ValueSet-v2-0615.md)
  * Name: hl7VS-userAuthenticationCredentialTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a type of user authentication credential.
* Identity: [v2-0616](ValueSet-v2-0616.md)
  * Name: hl7VS-addressExpirationReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the reason this address was marked as "ended".
* Identity: [v2-0617](ValueSet-v2-0617.md)
  * Name: hl7VS-addressUsage
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify how an address is intended to be used.
* Identity: [v2-0618](ValueSet-v2-0618.md)
  * Name: hl7VS-protectionCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify that an address needs to be treated with special care or sensitivit…
* Identity: [v2-0625](ValueSet-v2-0625.md)
  * Name: hl7VS-itemStatusCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the state of an inventory item within the context of an inventory l…
* Identity: [v2-0634](ValueSet-v2-0634.md)
  * Name: hl7VS-itemImportanceCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that denote a level or importance of an inventory item within the context of an …
* Identity: [v2-0642](ValueSet-v2-0642.md)
  * Name: hl7VS-reorderTheoryCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the calculation method used to determine the resupply schedule.
* Identity: [v2-0651](ValueSet-v2-0651.md)
  * Name: hl7VS-laborCalculationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the method used to calculate employee labor and measure employee pr…
* Identity: [v2-0653](ValueSet-v2-0653.md)
  * Name: hl7VS-dateFormat
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the date format for a decontamination/sterilization instance.
* Identity: [v2-0657](ValueSet-v2-0657.md)
  * Name: hl7VS-deviceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the kind of device as defined by the manufacturer.
* Identity: [v2-0659](ValueSet-v2-0659.md)
  * Name: hl7VS-lotControl
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the sterilization load for a device is built in the sub-ste…
* Identity: [v2-0667](ValueSet-v2-0667.md)
  * Name: hl7VS-deviceDataState
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the state of the data as provided from a device.
* Identity: [v2-0669](ValueSet-v2-0669.md)
  * Name: hl7VS-loadStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the information provided in a device sterilization or…
* Identity: [v2-0682](ValueSet-v2-0682.md)
  * Name: hl7VS-deviceStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the state of a device.
* Identity: [v2-0702](ValueSet-v2-0702.md)
  * Name: hl7VS-cycleType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of cycle that is being executed. A cycle type is a specif…
* Identity: [v2-0717](ValueSet-v2-0717.md)
  * Name: hl7VS-accessRestrictionValue
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the information to which access is restricted. Note that the new c…
* Identity: [v2-0725](ValueSet-v2-0725.md)
  * Name: hl7VS-moodCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the functional state of an order.
* Identity: [v2-0728](ValueSet-v2-0728.md)
  * Name: hl7VS-cclValue
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the clinical complexity level (CCL) value for the determined diagno…
* Identity: [v2-0731](ValueSet-v2-0731.md)
  * Name: hl7VS-drgDiagnosisDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of a diagnosis for a diagnosis related group (DRG) deter…
* Identity: [v2-0734](ValueSet-v2-0734.md)
  * Name: hl7VS-grouperStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of a grouper in general.
* Identity: [v2-0739](ValueSet-v2-0739.md)
  * Name: hl7VS-statusPatient
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify whether the length of stay is normal or respectively shorter or lon…
* Identity: [v2-0742](ValueSet-v2-0742.md)
  * Name: hl7VS-drgStatusFinancialCalculation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the diagnosis related group (DRG) calculation regardi…
* Identity: [v2-0749](ValueSet-v2-0749.md)
  * Name: hl7VS-drgGroupingStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the use of the gender information for diagnosis relat…
* Identity: [v2-0755](ValueSet-v2-0755.md)
  * Name: hl7VS-statusWeightAtBirth
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the use of the weight at birth for diagnosis related …
* Identity: [v2-0757](ValueSet-v2-0757.md)
  * Name: hl7VS-statusRespirationMinutes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the use of the respiration minutes information for di…
* Identity: [v2-0759](ValueSet-v2-0759.md)
  * Name: hl7VS-statusAdmission
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the admission status for the diagnosis related group (DRG) determin…
* Identity: [v2-0761](ValueSet-v2-0761.md)
  * Name: hl7VS-drgProcedureDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status of the use of this particular procedure for the diagnosi…
* Identity: [v2-0763](ValueSet-v2-0763.md)
  * Name: hl7VS-drgProcedureRelevance
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the relevance of this particular procedure for the diagnosis relate…
* Identity: [v2-0776](ValueSet-v2-0776.md)
  * Name: hl7VS-itemStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the status (useful for reporting and item usage purposes) that appl…
* Identity: [v2-0778](ValueSet-v2-0778.md)
  * Name: hl7VS-itemType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify a classification of material items into like groups as defined and …
* Identity: [v2-0790](ValueSet-v2-0790.md)
  * Name: hl7VS-approvingRegulatoryAgency
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the regulatory agency by which the item has been approved, such as …
* Identity: [v2-0793](ValueSet-v2-0793.md)
  * Name: hl7VS-rulingAct
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify an act containing a rule that the item is legally required to be in…
* Identity: [v2-0806](ValueSet-v2-0806.md)
  * Name: hl7VS-sterilizationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the type of sterilization used for sterilizing the inventory supply i…
* Identity: [v2-0818](ValueSet-v2-0818.md)
  * Name: hl7VS-package
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the packaging unit in which this inventory supply item can be ordered…
* Identity: [v2-0868](ValueSet-v2-0868.md)
  * Name: hl7VS-telecommunicationExpirationReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the reason this contact number/email was marked as "ended".
* Identity: [v2-0871](ValueSet-v2-0871.md)
  * Name: hl7VS-supplyRiskCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying any known or suspected hazard associated with this material item.
* Identity: [v2-0881](ValueSet-v2-0881.md)
  * Name: hl7VS-roleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the account role of the physician, for example, only billing for the …
* Identity: [v2-0882](ValueSet-v2-0882.md)
  * Name: hl7VS-medicalRoleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the role of the physician ("self-employed" or "employed").
* Identity: [v2-0894](ValueSet-v2-0894.md)
  * Name: hl7VS-sideOfBody
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the side of the body ("left" or "right").
* Identity: [v2-0895](ValueSet-v2-0895.md)
  * Name: hl7VS-presentOnAdmission(poa)Indicator
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the present on admission indicator for this particular diagnosis.
* Identity: [v2-0904](ValueSet-v2-0904.md)
  * Name: hl7VS-securityCheckScheme
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the scheme for a security check.
* Identity: [v2-0905](ValueSet-v2-0905.md)
  * Name: hl7VS-shipmentStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the status of a shipment.
* Identity: [v2-0906](ValueSet-v2-0906.md)
  * Name: hl7VS-actpriority
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the priority for a shipment.
* Identity: [v2-0907](ValueSet-v2-0907.md)
  * Name: hl7VS-confidentiality
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the confidentiality for a shipment.
* Identity: [v2-0909](ValueSet-v2-0909.md)
  * Name: hl7VS-patientResultsReleaseCategorizationScheme
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the scheme for the patient results release categorization.
* Identity: [v2-0912](ValueSet-v2-0912.md)
  * Name: hl7VS-participation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that represent functional involvement of a caregiver or member of a care team with an acti…
* Identity: [v2-0914](ValueSet-v2-0914.md)
  * Name: hl7VS-rootCause
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a root cause.
* Identity: [v2-0916](ValueSet-v2-0916.md)
  * Name: hl7VS-relevantClincialInformation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify additional clinical information about the patient or specimen to re…
* Identity: [v2-0917](ValueSet-v2-0917.md)
  * Name: hl7VS-bolusType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a type of bolus.
* Identity: [v2-0918](ValueSet-v2-0918.md)
  * Name: hl7VS-pcaType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a type of PCA.
* Identity: [v2-0919](ValueSet-v2-0919.md)
  * Name: hl7VS-exclusiveTest
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that define if a test should be a specific event with no other tests to be performed with …
* Identity: [v2-0920](ValueSet-v2-0920.md)
  * Name: hl7VS-preferredSpecimen-AttributeStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a p…
* Identity: [v2-0921](ValueSet-v2-0921.md)
  * Name: hl7VS-certificationTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the code for a certification type.
* Identity: [v2-0922](ValueSet-v2-0922.md)
  * Name: hl7VS-certificationCategoryCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the code for a certification category.
* Identity: [v2-0923](ValueSet-v2-0923.md)
  * Name: hl7VS-processInterruption
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying whether a process was interrrupted and whether a needle had been inse…
* Identity: [v2-0924](ValueSet-v2-0924.md)
  * Name: hl7VS-cumulativeDosageLimitUom
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the unit of measure (UoM) for the cumulative dosage limit.
* Identity: [v2-0925](ValueSet-v2-0925.md)
  * Name: hl7VS-phlebotomyIssue
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a phlebotomy issue.
* Identity: [v2-0926](ValueSet-v2-0926.md)
  * Name: hl7VS-phlebotomyStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the status of a phlebotomy.
* Identity: [v2-0927](ValueSet-v2-0927.md)
  * Name: hl7VS-armStick
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the arm(s) receiving a stick.
* Identity: [v2-0929](ValueSet-v2-0929.md)
  * Name: hl7VS-weightUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes of units of measure that are used to specify weight.
* Identity: [v2-0930](ValueSet-v2-0930.md)
  * Name: hl7VS-volumeUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes of units of measure that are used to specify volume.
* Identity: [v2-0931](ValueSet-v2-0931.md)
  * Name: hl7VS-temperatureUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the units of transport temperature.
* Identity: [v2-0932](ValueSet-v2-0932.md)
  * Name: hl7VS-donationDurationUnits
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the units of donation duration.
* Identity: [v2-0933](ValueSet-v2-0933.md)
  * Name: hl7VS-intendedProcedureType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the type of intended procedure.
* Identity: [v2-0935](ValueSet-v2-0935.md)
  * Name: hl7VS-processInterruptionReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the reason for a process interruption.
* Identity: [v2-0936](ValueSet-v2-0936.md)
  * Name: hl7VS-VS-observationType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify types of observations to enable systems to distinguish between obse…
* Identity: [v2-0937](ValueSet-v2-0937.md)
  * Name: hl7VS-VS-observationSubtype
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying an observation sub-type.
* Identity: [v2-0938](ValueSet-v2-0938.md)
  * Name: hl7VS-VS-collectionEvent
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the limit for a collection event or process step.
* Identity: [v2-0939](ValueSet-v2-0939.md)
  * Name: hl7VS-VS-communicationLocation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a communication location.
* Identity: [v2-0940](ValueSet-v2-0940.md)
  * Name: hl7VS-VS-limitationTypeCode
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying a type of limitation.
* Identity: [v2-0942](ValueSet-v2-0942.md)
  * Name: V2 Table 0942 Version Master
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of measurement of the state of an automated laboratory ins…
* Identity: [v2-0945](ValueSet-v2-0945.md)
  * Name: hl7VS-auto-DilutionType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the pre‑configured dilution to be applied on the instrument, which …
* Identity: [v2-0946](ValueSet-v2-0946.md)
  * Name: hl7VS-supplierType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the type of supplier that will distribute the supply items associated…
* Identity: [v2-0948](ValueSet-v2-0948.md)
  * Name: hl7VS-relationshipType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that specify the type of relationship that is established between the instances …
* Identity: [v2-0949](ValueSet-v2-0949.md)
  * Name: hl7VS-orderControlCodeReason
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that describe reasons for the chosen order control codes.
* Identity: [v2-0950](ValueSet-v2-0950.md)
  * Name: hl7VS-orderStatusModifier
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that further define an identified status.
* Identity: [v2-0951](ValueSet-v2-0951.md)
  * Name: hl7VS-ReasonForStudy
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that provide additional information to the universal service identifier on why a…
* Identity: [v2-0952](ValueSet-v2-0952.md)
  * Name: Confidentiality
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts drawn from the HL7 V3 Confidentiality code system . Used in Version 2 messaging in the Se…
* Identity: [v2-0959](ValueSet-v2-0959.md)
  * Name: workClassificationODH
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: A person’s employment type as defined by compensation and sector (e.g. paid vs. unpaid, self-employ…
* Identity: [v2-0961](ValueSet-v2-0961.md)
  * Name: DeviceType
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Codes used to identify medical devices.
* Identity: [v2-0962](ValueSet-v2-0962.md)
  * Name: FHIRdeviceStatus
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: The availability status of the device.
* Identity: [v2-0970](ValueSet-v2-0970.md)
  * Name: hl7VS-onlineVerificationResult
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code values used to indicate the result of an online verification of insurance data.
* Identity: [v2-0971](ValueSet-v2-0971.md)
  * Name: hl7VS-onlineVerificationResultErrorCodes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: V2 Table 0971 Version Master (Online Verification Result Error Code)
* Identity: [v2-4000](ValueSet-v2-4000.md)
  * Name: hl7VS-name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that provide an indication of the kind of representation provided by a name or a…
* Identity: [v2-notAllCodes-0291](ValueSet-v2-notAllCodes-0291.md)
  * Name: hl7VS-subtypeOfReferencedData
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: A subset of the IANA media subtypes of binary data that are encoded in an ascii structure or stream.
* Identity: [v2-notAllCodes-0347](ValueSet-v2-notAllCodes-0347.md)
  * Name: HL7 Value Set for State/Province
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Concepts used to specify a state or province. Used in Version 2 messaging in the Extended Composit…
* Identity: [v2-notAllCodes-0399](ValueSet-v2-notAllCodes-0399.md)
  * Name: hl7VS-countryCode-3alpha
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes that identifies a country of origin for a message. It will be used primarily to…
* Identity: [v2-notAllCodes-0834](ValueSet-v2-notAllCodes-0834.md)
  * Name: hl7VS-mimeTypes
  * Version: 2.0.0
  * Status: active
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Value Set of codes specifying the general type of data.

Showing 439 of 439 entries

