# Using pCLOCD with HL7 Standards - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* [**External Code Systems**](external_code_systems.md)
* **Using pCLOCD with HL7 Standards**

## Using pCLOCD with HL7 Standards

This page describes how to use pCLOCD with HL7 Standards.

### Using pCLOCD with FHIR R5

#### Summary

| | |
| :--- | :--- |
| Source | pCLOCD is made available by[Canada Health Infoway](https://www.infoway-inforoute.ca/)at[https://tgateway.infoway-inforoute.ca/pclocd.html](https://tgateway.infoway-inforoute.ca/pclocd.html). |
| System | The URI[https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD](https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD)identifies pCLOCD codes. |
| Version | Where a version is used, it should include the appropriate version number of pCLOCD (e.g. R05.11.00_2.67). |
| Code | The LOINC Code Identifier e.g. 21176-3. LOINC codes are not case sensitive. In addition, LOINC part codes and LOINC answer string ids can be used where appropriate. |
| Display | Use either the Pan-Canadian Name EN or Pan-Canadian Name FR field for the display. |
| Inactive | Codes with Property pCLOCD Status = Inactive are considered inactive for use in ValueSet.compose.inactive. |
| Filter Properties | Several properties are defined as described below. |

#### Copyright Issues

Users may incorporate portions of pCLOCD into another document (e.g., an implementation guide or other technical specification) for distribution outside of the User's corporation or organization, subject to these terms in addition to the terms and conditions specified in the LOINC and RELMA Terms of Use.

Every copy of the document that contains portions of the pCLOCD table must include the following notice:

"This material contains content from the pan-Canadian LOINC® Observation Code Database (pCLOCD). Canada Health Infoway Inc. (Infoway) has created pCLOCD from LOINC® to address local requirements in Canada. Infoway maintains the copyright on these localized additions. pCLOCD is available at no cost to users with Standards Access. Access to pan-Canadian standards and supporting information is available to anyone who accepts the applicable license agreements annually. Link to pCLOCD Terms of Use is https://infocentral.infoway-inforoute.ca/8_UserReferencesAndSupports/Terms_And_License_Agreements/pCLOCD_Terms_of_Use. This material also includes a portion of the LOINC table and is subject to a license from Regenstrief Institute, Inc. which is available at [http://loinc.org/terms-of-use](http://loinc.org/terms-of-use)."

User is required to indicate the appropriate version number of pCLOCD used.

Any information in the document that is extracted from the pCLOCD Nomenclature table must always be associated with the corresponding LOINC/pCLOCD code.

#### Case Sensitivity

For comparison purposes, LOINC/pCLOCD codes, displays, and property values are not case sensitive, though implementers SHOULD maintain the correct case when using LOINC/pCLOCD codes and property values.

#### pCLCOD Properties

In addition to the [standard properties](https://hl7.org/fhir/terminology-service.html#standard-props), the following pCLOCD table fields are defined as code system properties when using pCLOCD in FHIR:

| | | |
| :--- | :--- | :--- |
| **Property Name** | **Data Type** | **Comments** |
| Pan-Canadian Component Name - EN | string | This attribute contains the pan-Canadian "English" Component Name. The name either directly reflects the LOINC Component Name or is based on that name but is translated to terms commonly used in Canada. This name may be blank in situations where the Component Name should not form part of the pan-Canadian Display Name. |
| Pan-Canadian Component Name-FR | string | This attribute contains the pan-Canadian "French" Component Name. The name either directly reflects the FR LOINC Component Name or is based on that name but is translated to terms commonly used in Canada. This name may be blank in situations where the Component Name should not form part of the pan-Canadian FR Display Name. |
| pan-Canadian Name - EN | string | This attribute contains the suggested fully extended English name that is based on the English pan-Canadian Component Name and any augmented attributes that have been indicated as "yes". It can be used by systems to display or search for a test description (name). It is used in pan-Canadian conformant messages. |
| Pan-Canadian Name -FR | string | This attribute contains the suggested fully extended French name that is based on the Component and any augmented attributes that have been indicated as "yes". It can be used by systems to display or search for a test description (name). It is used in pan-Canadian conformant messages. |
| Example Viewer Name - EN | string | This attribute contains an example French viewer name that is based on the Laboratory_Viewer_Name_Guiding_Principles_and_Rules_V3.0-20130513.pdf document. It can be used to provide nomenclature for any jurisdictional viewer, but must not be used for pan Canadian Messaging or mapping of LIS test catalogues. It is published as an example for implementers. |
| Example Viewer Name - FR | string | This attribute contains an example French viewer name that is based on theLaboratory_Viewer_Name_Guiding_Principles_and_Rules_V3.0-20130513.pdf document. It can be used to provide nomenclature for any jurisdictional viewer, but must not be used for pan Canadian Messaging or mapping of LIS test catalogues. It is published as an example for implementers. |
| B/R/O | string | Provides users with an idea of the intended use of the term by categorizing it as an order only (O), result only (R ) , or both (B) |
| LN COMPONENT | code | LOINC first major axis-component or analyte: Analyte Name, Analyte sub-class, Challenge |
| LN PROPERTY | code | LOINC second major axis-property observed: Kind of Property (also called kind of quantity) |
| LN TIME_ASPCT | code | LOINC third major axis-timing of the measurement: Time Aspect (Point or moment in time vs. time interval) |
| LN SYSTEM | code | LOINC fourth major axis-type of specimen or system: System (Sample) Type |
| LN SCALE_TYP | code | LOINC fifth major axis-scale of measurement: Type of Scale |
| LN METHOD_TYP | code | LOINC sixth major axis-method of measurement: Type of Method |
| LN SHORTNAME | string | LOINC fully specified name |
| LN CLASS | string | An arbitrary classification of the terms for grouping related observations together |
| Sub-Class | String | This attribute is used to further categorize the LOINC Class attribute. Currently, Microbiology is the only class that has been subdivided. This attribute will facilitate review in large classes. |
| LN STATUS | string | LOINC Status of the term |
| LN LONG COMMON NAME | string | These names have been created by an algorithmic process and are checked for uniqueness. Most abbreviations and acronyms that are used in the LOINC database have been fully spelled out in English. For allergens, the common English names are used instead of the more formal Latin species names. For coagulation, the more commonly used phrases such as “Prothrombin time” have been used. |
| LN ÉLÉMENT (Component) | code | Canadian French translation of LOINC first major axis-component or analyte: Analyte Name, Analyte sub-class, Challenge |
| LN PROPRIÉTÉ (Property) | code | Canadian French translation of LOINC second major axis-property observed: Kind of Property (also called kind of quantity) |
| LN DURÉE (Time) | code | Canadian French translation of LOINC third major axis-timing of the measurement: Time Aspect (Point or moment in time vs. time interval) |
| LN SYSTÈME (System) | code | Canadian French translation of LOINC fourth major axis-type of specimen or system: System (Sample) Type |
| LN ÉCHELLE (Scale) | code | Canadian French translation of LOINC fifth major axis-scale of measurement: Type of Scale |
| LN MÉTHODE (Method) | code | Canadian French translation of LOINC sixth major axis-method of measurement: Type of Method |
| LN CATÉGORIE (Class) | code | Canadian French translation of LOINC arbitrary classification of the terms for grouping related observations together |
| SOUS-CATÉGORIE (Sub-Class) | string | Canadian French translation of attribute used to further categorize the LOINC Class attribute. Currently, Microbiology is the only class that has been subdivided. This attribute will facilitate review in large classes. |
| pCLOCD Status | string | pCLOCD Status of term |
| MIS Service Activity Reporting (Y/N) | string | This field is used to identify pCLOCD codes that are counted as a service activity statistic as defined in the MIS Standards (Standards for Management Information Systems) published by the Canadian Institute for Health Information (CIHI). The field is managed by CIHI.Further information about service activity and the principles and process used to define this attribute may be obtained by reviewing the MIS Standards or emailing fsi@cihi.ca. 'Y' indicates it should be counted, 'N' indicates it should not be counted and 'X' indicates the pCLOCD code has not been evaluated. |

Note that when a [$lookup](https://hl7.org/fhir/codesystem-operation-lookup.html) operation is performed on a pCLOCD code, servers SHALL return the version being used (see above) in the 'version' property. Other properties are at the discretion of the server and the client.

