# x_ActClassDocumentEntryAct - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **x_ActClassDocumentEntryAct**

## ValueSet: x_ActClassDocumentEntryAct 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-xActClassDocumentEntryAct | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:XActClassDocumentEntryAct |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19599 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The set of Act class codes allowed for the ACT class clone in the CDA Clinical Statement model. The scope of this value set are those Act class codes not otherwise covered by specific classes in the CDA Clinical Statement model and required to enable representation of Clinical Statement in CDA. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-xActClassDocumentEntryAct",
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "name",
          "valueString" : "Name:Class"
        },
        {
          "url" : "value",
          "valueString" : "DocumentEntry"
        }
      ],
      "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/v3-xActClassDocumentEntryAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19599"
    }
  ],
  "version" : "3.0.0",
  "name" : "XActClassDocumentEntryAct",
  "title" : "x_ActClassDocumentEntryAct",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The set of Act class codes allowed for the ACT class clone in the CDA Clinical Statement model. The scope of this value set are those Act class codes not otherwise covered by specific classes in the CDA Clinical Statement model and required to enable representation of Clinical Statement in CDA.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
        "concept" : [
          {
            "code" : "ACCM"
          },
          {
            "code" : "ACSN"
          },
          {
            "code" : "ACT"
          },
          {
            "code" : "AEXPOS"
          },
          {
            "code" : "CONS"
          },
          {
            "code" : "CONTREG"
          },
          {
            "code" : "CTTEVENT"
          },
          {
            "code" : "DISPACT"
          },
          {
            "code" : "EXPOS"
          },
          {
            "code" : "INC"
          },
          {
            "code" : "INFRM"
          },
          {
            "code" : "LIST"
          },
          {
            "code" : "MPROT"
          },
          {
            "code" : "PCPR"
          },
          {
            "code" : "REG"
          },
          {
            "code" : "REV"
          },
          {
            "code" : "SPCTRT"
          },
          {
            "code" : "STORE"
          },
          {
            "code" : "TEXPOS"
          },
          {
            "code" : "TRFR"
          },
          {
            "code" : "TRNS"
          }
        ]
      }
    ]
  }
}

```
