# RoleClassSubstancePresence - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleClassSubstancePresence**

## ValueSet: RoleClassSubstancePresence 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-RoleClassSubstancePresence | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleClassSubstancePresence |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20387 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The presence of an bio-chemical entity (substance) at a location or environment, such as an ingredient in a mixture, molecular part of a complex, a located entity at a cellular structure, or content of a container, such as a vesicle. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-RoleClass`](CodeSystem-v3-RoleClass.md)version 📦4.0.0 where concept is-a [CONT](CodeSystem-v3-RoleClass.md#v3-RoleClass-CONT), concept is-a [INGR](CodeSystem-v3-RoleClass.md#v3-RoleClass-INGR), concept is-a [LOCE](CodeSystem-v3-RoleClass.md#v3-RoleClass-LOCE) and concept is-a [PART](CodeSystem-v3-RoleClass.md#v3-RoleClass-PART)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-RoleClassSubstancePresence",
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "name",
          "valueString" : "Name:Class"
        },
        {
          "url" : "value",
          "valueString" : "substancePresence"
        }
      ],
      "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueString" : "Name:Role:player:Entity"
        },
        {
          "url" : "value",
          "valueString" : "present&"
        }
      ],
      "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueString" : "Name:Role:scoper:Entity"
        },
        {
          "url" : "value",
          "valueString" : "environment&"
        }
      ],
      "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/v3-RoleClassSubstancePresence",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20387"
    }
  ],
  "version" : "3.0.0",
  "name" : "RoleClassSubstancePresence",
  "title" : "RoleClassSubstancePresence",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The presence of an bio-chemical entity (substance) at a location or environment, such as an ingredient in a mixture, molecular part of a complex, a located entity at a cellular structure, or content of a container, such as a vesicle.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "CONT"
          },
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "INGR"
          },
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "LOCE"
          },
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "PART"
          }
        ]
      }
    ]
  }
}

```
