# ProvenanceEventCurrentState - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProvenanceEventCurrentState**

## ValueSet: ProvenanceEventCurrentState 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState | *Version*:3.0.0 | |
| Active as of 2014-08-07 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProvenanceEventCurrentState |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20547 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Specifies the state change of a target Act, such as a document or an entry, from its previous state as a predecessor Act. 
For example, if the target Act is the result of a predecessor Act being "obsoleted" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be "obsoleted". 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Import all the codes that are contained in [ProvenanceEventCurrentState-AS](ValueSet-v3-ProvenanceEventCurrentState-AS.md)
* Import all the codes that are contained in [ProvenanceEventCurrentState-DC](ValueSet-v3-ProvenanceEventCurrentState-DC.md)
* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0

 

### Expansion

This value set has 1,313 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ProvenanceEventCurrentState",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20547"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProvenanceEventCurrentState",
  "title" : "ProvenanceEventCurrentState",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-08-07",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Specifies the state change of a target Act, such as a document or an entry, from its previous state as a predecessor Act.\r\n\r\nFor example, if the target Act is the result of a predecessor Act being \"obsoleted\" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be \"obsoleted\".",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState-AS"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState-DC"
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode"
      }
    ]
  }
}

```
