# HL7 ValueSet of Format Codes for use with Document Sharing - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7 ValueSet of Format Codes for use with Document Sharing**

## ValueSet: HL7 ValueSet of Format Codes for use with Document Sharing 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-HL7FormatCodes | *Version*:2.1.0 | |
| Active as of 2024-02-16 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HL7FormatCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.11.19752 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The HL7-FormatCodes value set is defined to be the set of FormatCode(s) defined by implementation guides published by HL7 and other SDOs. The use of a formatCode from the FormatCodes value set specifies the technical format that a document conforms to. The formatCode is a further specialization more detailed than the mime-type. The formatCode provides sufficient information to allow any potential document content consumer to know if it can process and/or display the content of the document based on the document encoding, structure and template conformance indicated by the formatCode. The set of formatCodes is intended to be extensible. The Content Logical Description is defined intentionally to permit formatCodes defined by other Standards Development Organizations to be added by inclusion of additional formatCode Code Systems. 

 **References** 

* [DocumentReference](http://hl7.org/fhir/R5/documentreference.html)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode`](http://tx.fhir.org/r5)version ⏿1.4.0 where status = active
* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes`](CodeSystem-v3-HL7DocumentFormatCodes.md)version 📦4.1.0

 

### Expansion

This value set contains 96 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-HL7FormatCodes",
  "url" : "http://terminology.hl7.org/ValueSet/v3-HL7FormatCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.19752"
    }
  ],
  "version" : "2.1.0",
  "name" : "HL7FormatCodes",
  "title" : "HL7 ValueSet of Format Codes for use with Document Sharing",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The HL7-FormatCodes value set is defined to be the set of FormatCode(s) defined by implementation guides published by HL7 and other SDOs. The use of a formatCode from the FormatCodes value set specifies the technical format that a document conforms to. The formatCode is a further specialization more detailed than the mime-type. The formatCode provides sufficient information to allow any potential document content consumer to know if it can process and/or display the content of the document based on the document encoding, structure and template conformance indicated by the formatCode. The set of formatCodes is intended to be extensible. The Content Logical Description is defined intentionally to permit formatCodes defined by other Standards Development Organizations to be added by inclusion of additional formatCode Code Systems.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
        "filter" : [
          {
            "property" : "status",
            "op" : "=",
            "value" : "active"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes"
      }
    ]
  }
}

```
