# Drug Entity - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Drug Entity**

## ValueSet: Drug Entity (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-DrugEntity | *Version*:2.0.0 | |
| Active as of 2022-10-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DrugEntity |
| *Other Identifiers:*OID:2.16.840.1.113883.11.21013 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A value representing the specific kind of Drug Entity the instance represents. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-EntityCode`](CodeSystem-v3-EntityCode.md)version 📦3.0.0 where concept is-a [_DrugEntity](CodeSystem-v3-EntityCode.md#v3-EntityCode-_DrugEntity)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-DrugEntity",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-DrugEntity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.21013"
    }
  ],
  "version" : "2.0.0",
  "name" : "DrugEntity",
  "title" : "Drug Entity",
  "status" : "active",
  "experimental" : true,
  "date" : "2022-10-11",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A value representing the specific kind of Drug Entity the instance represents.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_DrugEntity"
          }
        ]
      }
    ]
  }
}

```
