# CoveredPartyRoleType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CoveredPartyRoleType**

## ValueSet: CoveredPartyRoleType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-CoveredPartyRoleType | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CoveredPartyRoleType |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19805 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A role recognized through the eligibility of an identified living subject for benefits covered under an insurance policy or a program. Eligibility as a covered party may be conditioned on a relationship with (1) the policy holder such as the policy holder who is covered as an individual under a poliy or as a party sponsored for coverage by the policy holder. 
**Example:**An employee as a subscriber; or (2) on being scoped another covered party such as the subscriber, as in the case of a dependent. 
**Discussion:**The Abstract Value Set "CoverageRoleType", which was developed for use in the Canadian realm "pre-coordinate" coverage roles with other roles that a covered party must play in order to be eligible for coverage, e.g., "handicapped dependent". Other codes in the Abstract Value Set CoveredPartyRoleType domain can be "post-coordinated" with the EligiblePartyRoleType codes to denote comparable concepts. Decoupling the concepts is intended to support a wider range of concepts and semantic comparability of coded concepts. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0 where concept is-a [_CoveredPartyRoleType](CodeSystem-v3-RoleCode.md#v3-RoleCode-_CoveredPartyRoleType)
* Import all the codes that are contained in [ClaimantCoveredPartyRoleType](ValueSet-v3-ClaimantCoveredPartyRoleType.md)
* Import all the codes that are contained in [ProgramEligibleCoveredPartyRoleType](ValueSet-v3-ProgramEligibleCoveredPartyRoleType.md)
* Import all the codes that are contained in [IndividualInsuredCoveredPartyRoleType](ValueSet-v3-IndividualInsuredCoveredPartyRoleType.md)
* Import all the codes that are contained in [SubscriberCoveredPartyRoleType](ValueSet-v3-SubscriberCoveredPartyRoleType.md)
* Import all the codes that are contained in [DependentCoveredPartyRoleType](ValueSet-v3-DependentCoveredPartyRoleType.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](CodeSystem-v3-RoleCode.md)version 📦3.0.0 

 

### Expansion

This value set contains 16 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-CoveredPartyRoleType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-CoveredPartyRoleType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19805"
    }
  ],
  "version" : "3.0.0",
  "name" : "CoveredPartyRoleType",
  "title" : "CoveredPartyRoleType",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A role recognized through the eligibility of an identified living subject for benefits covered under an insurance policy or a program. Eligibility as a covered party may be conditioned on a relationship with (1) the policy holder such as the policy holder who is covered as an individual under a poliy or as a party sponsored for coverage by the policy holder.\r\n\r\n**Example:**An employee as a subscriber; or (2) on being scoped another covered party such as the subscriber, as in the case of a dependent.\r\n\r\n**Discussion:** The Abstract Value Set \"CoverageRoleType\", which was developed for use in the Canadian realm \"pre-coordinate\" coverage roles with other roles that a covered party must play in order to be eligible for coverage, e.g., \"handicapped dependent\". Other codes in the Abstract Value Set CoveredPartyRoleType domain can be \"post-coordinated\" with the EligiblePartyRoleType codes to denote comparable concepts. Decoupling the concepts is intended to support a wider range of concepts and semantic comparability of coded concepts.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_CoveredPartyRoleType"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ClaimantCoveredPartyRoleType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ProgramEligibleCoveredPartyRoleType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-IndividualInsuredCoveredPartyRoleType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-SubscriberCoveredPartyRoleType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-DependentCoveredPartyRoleType"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "_ClaimantCoveredPartyRoleType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "_ProgramEligiblePartyRoleType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "_IndividualInsuredPartyRoleType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "_SubscriberCoveredPartyRoleType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "_DependentCoveredPartyRoleType"
          }
        ]
      }
    ]
  }
}

```
