# ControlActReason - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ControlActReason**

## ValueSet: ControlActReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ControlActReason | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ControlActReason |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19692 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies why a specific query, request, or other trigger event occurred. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0 where concept is-a [_ControlActReason](CodeSystem-v3-ActReason.md#v3-ActReason-_ControlActReason)
* Import all the codes that are contained in [GenericUpdateReasonCode](ValueSet-v3-GenericUpdateReasonCode.md)
* Import all the codes that are contained in [CombinedPharmacyOrderSuspendReasonCode](ValueSet-v3-CombinedPharmacyOrderSuspendReasonCode.md)
* Import all the codes that are contained in [MedicationOrderAbortReasonCode](ValueSet-v3-MedicationOrderAbortReasonCode.md)
* Import all the codes that are contained in [MedicationOrderReleaseReasonCode](ValueSet-v3-MedicationOrderReleaseReasonCode.md)
* Import all the codes that are contained in [PatientProfileQueryReasonCode](ValueSet-v3-PatientProfileQueryReasonCode.md)
* Import all the codes that are contained in [PharmacySupplyRequestRenewalRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestRenewalRefusalReasonCode.md)
* Import all the codes that are contained in [SupplyOrderAbortReasonCode](ValueSet-v3-SupplyOrderAbortReasonCode.md)
* Import all the codes that are contained in [ControlActNullificationReasonCode](ValueSet-v3-ControlActNullificationReasonCode.md)
* Import all the codes that are contained in [StatusRevisionRefusalReasonCode](ValueSet-v3-StatusRevisionRefusalReasonCode.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0 

 

### Expansion

This value set contains 191 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ControlActReason",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ControlActReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19692"
    }
  ],
  "version" : "3.0.0",
  "name" : "ControlActReason",
  "title" : "ControlActReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies why a specific query, request, or other trigger event occurred.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_ControlActReason"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-GenericUpdateReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-CombinedPharmacyOrderSuspendReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-MedicationOrderAbortReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-MedicationOrderReleaseReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-PatientProfileQueryReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-PharmacySupplyRequestRenewalRefusalReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-SupplyOrderAbortReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ControlActNullificationReasonCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-StatusRevisionRefusalReasonCode"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "concept" : [
          {
            "code" : "_MedicationOrderAbortReasonCode"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "concept" : [
          {
            "code" : "_MedicationOrderReleaseReasonCode"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "concept" : [
          {
            "code" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "concept" : [
          {
            "code" : "_SupplyOrderAbortReasonCode"
          }
        ]
      }
    ]
  }
}

```
