# ActClassSemiFowlers - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActClassSemiFowlers**

## ValueSet: ActClassSemiFowlers 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActClassSemiFowlers | *Version*:2.0.0 |
| Retired as of 2014-03-26 | *Computable Name*:ActClassSemiFowlers |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20249 | |

 
**Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActClass`](CodeSystem-v3-ActClass.md)version 📦4.0.0 where concept is-a [SFWL](CodeSystem-v3-ActClass.md#v3-ActClass-SFWL)

 

### Expansion

Expansions are not generated for retired value sets

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActClassSemiFowlers",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActClassSemiFowlers",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20249"
    }
  ],
  "version" : "2.0.0",
  "name" : "ActClassSemiFowlers",
  "title" : "ActClassSemiFowlers",
  "status" : "retired",
  "experimental" : false,
  "date" : "2014-03-26",
  "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release.",
  "immutable" : true,
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "SFWL"
          }
        ]
      }
    ]
  }
}

```
