# ActClassCareProvision - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActClassCareProvision**

## ValueSet: ActClassCareProvision 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActClassCareProvision | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActClassCareProvision |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20233 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
An**Act**that of taking on whole or partial responsibility for, or attention to, safety and well-being of a subject of care. 
**Discussion:**A**care provision**event may exist without any other care actions taking place. For example, when a patient is assigned to the care of a particular health professional. 
In**request**(RQO) mood**care provision**communicates a referral, which is a request: 
* from one party (linked as a **participant** of type **author** (AUT)),
* to another party (linked as a **participant** of type **performer** (PRF),
* to take responsibility for a scope specified by the code attribute,
* for an entity (linked as a **participant** of type **subject** (SBJ)).
 
The scope of the care for which responsibility is taken is identified by**code**attribute. 
In**event**(EVN) mood**care provision**indicates the effective time interval of a specified scope of responsibility by a**performer**(PRF) or set of**performers**(PRF) for a**subject**(SBJ). 
**Examples:** 
1. Referral from GP to a specialist.
1. Assignment of a patient or group of patients to the case list of a health professional.
1. Assignment of inpatients to the care of particular nurses for a working shift.
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActClass`](CodeSystem-v3-ActClass.md)version 📦4.0.0 where concept is-a [PCPR](CodeSystem-v3-ActClass.md#v3-ActClass-PCPR)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActClassCareProvision",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActClassCareProvision",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20233"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActClassCareProvision",
  "title" : "ActClassCareProvision",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "An **Act** that of taking on whole or partial responsibility for, or attention to, safety and well-being of a subject of care.\r\n\r\n*Discussion:* A **care provision** event may exist without any other care actions taking place. For example, when a patient is assigned to the care of a particular health professional.\r\n\r\nIn **request** (RQO) mood **care provision** communicates a referral, which is a request:\r\n\r\n *  from one party (linked as a **participant** of type **author** (AUT)),\r\n *  to another party (linked as a **participant** of type **performer** (PRF),\r\n *  to take responsibility for a scope specified by the code attribute,\r\n *  for an entity (linked as a **participant** of type **subject** (SBJ)).\r\n\r\nThe scope of the care for which responsibility is taken is identified by *code* attribute.\r\n\r\nIn **event** (EVN) mood **care provision** indicates the effective time interval of a specified scope of responsibility by a **performer** (PRF) or set of **performers** (PRF) for a **subject** (SBJ).\r\n\r\n*Examples:*\r\n\r\n1.  Referral from GP to a specialist.\r\n2.  Assignment of a patient or group of patients to the case list of a health professional.\r\n3.  Assignment of inpatients to the care of particular nurses for a working shift.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "PCPR"
          }
        ]
      }
    ]
  }
}

```
