# MIF Concept Relationship Symmetry - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF Concept Relationship Symmetry**

## ValueSet: MIF Concept Relationship Symmetry 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/mif-conceptRelationshipSymmetry | *Version*:1.0.0 | |
| Draft as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MIFConceptRelationshipSymmetry |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for use in the ext-mif-relationship-symmetry to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.symmetry values 

 **References** 

* [MIF concept relationship symmetry](StructureDefinition-ext-mif-relationship-symmetry.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra`](CodeSystem-hl7TermMaintInfra.md)version 📦3.0.0 where concept is-a [MIF-ConceptRelationshipSymmetry](CodeSystem-hl7TermMaintInfra.md#hl7TermMaintInfra-MIF-ConceptRelationshipSymmetry)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra`](CodeSystem-hl7TermMaintInfra.md)version 📦3.0.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "mif-conceptRelationshipSymmetry",
  "url" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipSymmetry",
  "version" : "1.0.0",
  "name" : "MIFConceptRelationshipSymmetry",
  "title" : "MIF Concept Relationship Symmetry",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for use in the ext-mif-relationship-symmetry to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.symmetry values",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "MIF-ConceptRelationshipSymmetry"
          }
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
        "concept" : [
          {
            "code" : "MIF-ConceptRelationshipSymmetry"
          }
        ]
      }
    ]
  }
}

```
